//
//  CommodityListViewController.m
//  ALand
//
//  Created by Z on 16/3/23.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "CommodityListViewController.h"
#import "CommodityListCollectionViewCell.h"
#import "SortView.h"
#import "CommodityDetailViewController.h"
#import "CommotityRequestModel.h"
#import "HotBrandModel.h"
#import "CatgoryModel.h"
#import "JavenHotTagsModel.h"
#import "CommodityListModel/CommotityListModel.h"

#define kCellID @"commodityCell"
#define kPageSize @10
@interface CommodityListViewController ()<UICollectionViewDataSource, UICollectionViewDelegate>
@property (nonatomic, strong) UICollectionView *collectionView;
@property (nonatomic, strong) SortView *sortView;
@property (nonatomic, strong) NSMutableArray *arrItemDatas;
@property (nonatomic, assign) NSInteger page;
@property (nonatomic, copy) NSString *field; //排序的字段
@property (nonatomic, copy) NSString *direction;  //排序的顺序 升序或降序


@end

@implementation CommodityListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    //配置navigationbar
    self.navigationItem.title = @"商品列表";
    self.view.backgroundColor = kBacroundColor;
    self.field = @"";
    self.direction = @"desc";
    
    [self setUpSortView];
    [self setUpCollectionView];
    [self setUpData];
    // Do any additional setup after loading the view.
}

- (NSMutableArray *)arrItemDatas {
    if (!_arrItemDatas) {
        _arrItemDatas = [NSMutableArray array];
    }
    return _arrItemDatas;
}

- (void)setUpData {
    
    //前期发送请求生成参数的方式，后来不这么做了
 
    NSString *parameters;
    NSString *operation;
    if ([self.model isKindOfClass:[HotBrandModel class]]) {//热门品牌
        
        //设置请求模型
        HotBrandModel *model = self.model;
        operation = @"goodsData brand uuid equals";
        parameters = model.uuid;
        
    }else if([self.model isKindOfClass:[CatgoryModel class]]){//分类
        CatgoryModel *model = self.model;
        operation = @"goodsData category uuid equals";
        parameters = model.uuid;
        
    }else if ([self.model isKindOfClass:[JavenHotTagsModel class]]){//热门标签
        CatgoryModel *model = self.model;
        operation = @"goodsData category uuid equals";
        parameters = model.uuid;
    }
    
    NSDictionary *myDictionary = @{@"defintion" : @{@"conditions" : @[@{@"operation" : @"domain equals",
                                                                        @"parameter" : @{@"operation" : @"string"},
                                                                        @"parameters" : @[[UserInfo shareInstance].domain]},
                                                                      @{@"operation" : operation,
                                                                        @"parameter" : @{@"operation" : @"string"},
                                                                        @"parameters" : @[parameters]}],
                                                    @"orders" : @[@{@"field" : self.field,
                                                                    @"direction" : self.direction}],
                                                    @"pageSize" : kPageSize,
                                                    @"page" : @0,
                                                    @"probePages" : @0},
                                   @"fetchParts" : @[@"string"]};
    NSString *string = [myDictionary mj_JSONString];
    
    WS(weakSelf)
    [[HTTPCilent shareCilent] POST:@"goods/query2" parameters:myDictionary success:^(NSURLSessionDataTask *task, id responseObject) {
        
        for (NSDictionary *dic in responseObject[@"queryResult"]) {
            CommotityListModel *model = [CommotityListModel modelObjectWithDictionary:dic];
            [weakSelf.arrItemDatas addObject:model];
        }
        
        [weakSelf.collectionView reloadData];
    } failure:^(NSURLSessionDataTask *task, NSError *error) {
        
    }];
    
    
}



- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:NO];
}

- (void)setUpSortView {
    _sortView = [[[SortView alloc] init] customNew];
    [self.view addSubview:_sortView];
    _sortView.sd_layout.topSpaceToView(self.view,1).leftEqualToView(self.view).rightEqualToView(self.view).heightIs(44);
    _sortView.backgroundColor = [UIColor whiteColor];
    
    
    //点击排序列表之后回调传入选中行数 筛选
    WS(weakSelf)
    _sortView.selecedBlock = ^(NSInteger row){
        [weakSelf sortAction:row];
        CLog(@"%ld", (long)row);
    };
    
    _sortView.rightAction = ^(){
        weakSelf.field = @"salesvolume";
        weakSelf.direction = @"desc";
        [weakSelf resetReloadData];
    };
    
}

//排序
- (void)sortAction:(NSInteger)row {
    switch (row) {
        case 0:
        {
            self.field = @"";
            self.direction = @"desc";
        }
            break;
        case 1://价格 高-低
        {
            self.field = @" spec price";
            self.direction = @"desc";
        }
            break;
        case 2://价格 低-高
        {
            self.field = @" spec price";
            self.direction = @"asc";
        }
            break;
        case 3://佣金
        {
            self.field = @"brokerageRate";
            self.direction = @"desc";
        }
            break;
        case 4:
        {
            self.field = @"brokerageRate";
            self.direction = @"asc";
        }
            break;
        case 5://点击量
        {
            self.field = @"visited";
            self.direction = @"desc";
        }
            break;
        case 6:
        {
            self.field = @"visited";
            self.direction = @"asc";
        }
            break;
            
        default:
            break;
    }
    [self resetReloadData];
}

//改变排序条件之后重新请求数据
- (void)resetReloadData {
    [self.arrItemDatas removeAllObjects];
    [self setUpData];
    
}


- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.sortView hide];
}


- (void)setUpCollectionView {
    UICollectionViewFlowLayout *layOut = [[UICollectionViewFlowLayout alloc] init];
    layOut.minimumLineSpacing = 10;
    layOut.itemSize = CGSizeMake((ScreenSize.width - 30)/2, ScreenSize.height / 2.2);
    
    _collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layOut];
    [self.view addSubview:_collectionView];
    _collectionView.sd_layout.topSpaceToView(self.view, 50).leftEqualToView(self.view).bottomEqualToView(self.view).rightEqualToView(self.view);
    _collectionView.contentInset = UIEdgeInsetsMake(0, 10, 0, 10);
    _collectionView.delegate = self;
    _collectionView.dataSource = self;
    _collectionView.backgroundColor = kBacroundColor;
    [_collectionView registerNib:[UINib nibWithNibName:@"CommodityListCollectionViewCell" bundle:[NSBundle mainBundle]] forCellWithReuseIdentifier:kCellID];
}


- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.arrItemDatas.count;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    CommodityDetailViewController *detailVC = [[CommodityDetailViewController alloc] init];
    [self.navigationController pushViewController:detailVC animated:YES];
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    CommodityListCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:kCellID forIndexPath:indexPath];
    cell.successBlock = ^{
        
    };
    [cell cellWithModel:self.arrItemDatas[indexPath.row]];
    return cell;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
