//
//  CommodityDetailViewController.m
//  ALand
//
//  Created by Z on 16/3/28.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "CommodityDetailViewController.h"
#import "CommodityDetailBottomView.h"
#import "CommodityDetailTopView.h"
#import "CommodityMutipleSelectBottomView.h"
@interface CommodityDetailViewController ()
@property (nonatomic, strong) CommodityDetailBottomView *bottomView;
@property (nonatomic, strong) CommodityDetailTopView *topView;
@end

@implementation CommodityDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    if ([[[UIDevice currentDevice] systemVersion] doubleValue] > 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
    }
    self.view.backgroundColor = kBacroundColor;
    
    UIWebView *webView = [[UIWebView alloc] initWithFrame:CGRectMake(0, 0, kWidth, kHeight - 67)];
    NSURL *url = [NSURL URLWithString:@"https://m.jd.com"];
    [webView loadRequest:[NSURLRequest requestWithURL:url]];
    [self.view addSubview:webView];
    webView.userInteractionEnabled = YES;
    
    
    [self.view addSubview:self.topView];
    
    
    WS(weakSelf)
    self.topView.bacBlock = ^{
        [weakSelf.navigationController popViewControllerAnimated:YES];
    };
    
    _topView.homeBlock = ^{
        CLog(@"home");
    };
    
    
    
    [self.view addSubview:self.bottomView];
    
    
    
    // Do any additional setup after loading the view.
}


//隐藏navigationbar
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:YES];
}


#pragma mark =========== lazy loading ===========
- (CommodityDetailBottomView *)bottomView {
    if (!_bottomView) {
        _bottomView = [CommodityDetailBottomView viewWithNibName:@"CommodityDetailBottomView"];
        
        _bottomView.frame = CGRectMake(0, kHeight - 67, kWidth, 67);
  
    }
    return _bottomView;
}

- (CommodityDetailTopView *)topView {
    if (!_topView) {
        _topView = [CommodityDetailTopView viewWithNibName:@"CommodityDetailTopView"];
        _topView.frame = CGRectMake(0, 0, kWidth, 86);
    }
    return _topView;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
