//
//  AddCommodityViewController.m
//  ALand
//
//  Created by Z on kMargin/3/25.
//  Copyright © 20kMargin年 Z. All rights reserved.
//

#import "AddCommodityViewController.h"
#import "AddCommodityCollectionViewCell.h"
#import "AddCommodityHeaderView.h"
#import "AddCommodityHeaderCollectionReusableView.h"
#import "HotCommodityCell.h"
#import "AddCommodityFooterCollectionReusableView.h"
#import "CommodityListViewController.h"
#import "HotBrandModel.h"
#import "CatgoryModel.h"
#import "JavenHotTagsModel.h"
#import "CommoditySearchViewController.h"

#define kHotCellId @"addCommodityCellHot"
#define kCellId @"addCommodityCell"
#define kHeaderId @"headerId"
#define kFooterId @"footerId"
#define kMargin 0
@interface AddCommodityViewController ()<UICollectionViewDataSource, UICollectionViewDelegate, UICollectionViewDelegateFlowLayout, UISearchBarDelegate>
@property (nonatomic, strong) NSMutableArray *arrData;
@property (nonatomic, strong) UICollectionView *collectionView;
@end

@implementation AddCommodityViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.navigationItem.title = @"添加商品";
    UIBarButtonItem *rightBtn = [[UIBarButtonItem alloc] initWithImage:[UIImage imageNamed:@"searchIcon"] style:UIBarButtonItemStyleDone target:self action:@selector(searchAct)];
    rightBtn.tintColor = kTextColorDarkGray;
    self.navigationItem.rightBarButtonItem = rightBtn;
    
    [self setUpCollectionView];
    [self updateStatueBarAppearance];
    [self setUpdata];
    // Do any additional setup after loading the view.
}
- (NSMutableArray *)arrData {
    if (!_arrData) {
        _arrData = [NSMutableArray array];
    }
    return _arrData;
}

- (void)searchAct {
    CLog(@"搜索");
    CommoditySearchViewController *searchVC = [[CommoditySearchViewController alloc] init];
    searchVC.isShowNavigationBar = YES;
    
    IBTUINavigationController *nc = [[IBTUINavigationController alloc] initWithRootViewController:searchVC];
    
//    [self.navigationController presentModalViewController:nc animated:NO];
    [self.navigationController presentViewController:nc animated:YES completion:nil];
    
}


- (void)setUpdata {
    WS(weakSelf)
    [[HTTPCilent shareCilent] GET:[NSString stringWithFormat:@"app/getGoodsFilter/%@", @"0001"] parameters:nil success:^(NSURLSessionDataTask *task, id responseObject) {
        
        NSMutableArray *arrHotBrand = [NSMutableArray array];
        for (NSDictionary *dic in responseObject[@"hotBrands"]) {
            [HotBrandModel mj_setupReplacedKeyFromPropertyName:^NSDictionary *{
                return @{@"aid":@"id",
                         @"adescription":@"description",
                         @"aoperator":@"operator"};
            }];
            HotBrandModel *model = [HotBrandModel mj_objectWithKeyValues:dic];
            [arrHotBrand addObject:model];
            CLog(@"d");
        }
        [weakSelf.arrData addObject:arrHotBrand];
        
        //热门标签
        NSMutableArray *arrHotTags = [NSMutableArray array];
        for (NSDictionary *dic in responseObject[@"hotTags"]) {
            JavenHotTagsModel *model = [JavenHotTagsModel modelObjectWithDictionary:dic];
            [arrHotTags addObject:model];
        }
        
        [weakSelf.arrData addObject:arrHotTags];
        
        //品牌
        NSMutableArray *arrCategory = [NSMutableArray array];
        for (NSDictionary *dic in responseObject[@"categories"]) {
            [CatgoryModel mj_setupReplacedKeyFromPropertyName:^NSDictionary *{
                return @{@"aid":@"id",
                         @"adescription":@"description",
                         @"aoperator":@"operator"};
            }];
            CatgoryModel *model = [CatgoryModel mj_objectWithKeyValues:dic];
            [arrCategory addObject:model];
        }
        [weakSelf.arrData addObject:arrCategory];
        
        [self.collectionView reloadData];
    } failure:^(NSURLSessionDataTask *task, NSError *error) {
        
    }];
}

//设置navigationbar颜色
- (UIStatusBarStyle)preferredStatusBarStyle {
    return UIStatusBarStyleDefault;
}

//隐藏navigationbar
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:NO];
}

- (void)setUpCollectionView {
    UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc] init];
    _collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
    [self.view addSubview:_collectionView];
    _collectionView.sd_layout.topEqualToView(self.view).leftEqualToView(self.view).bottomEqualToView(self.view).rightEqualToView(self.view);
    _collectionView.delegate = self;
    _collectionView.dataSource = self;
    _collectionView.backgroundColor = kSysWhite;
    _collectionView.contentInset = UIEdgeInsetsMake(0, kMargin, 0, kMargin);
    
    //cell
    [_collectionView registerNib:[UINib nibWithNibName:@"HotCommodityCell" bundle:[NSBundle mainBundle]] forCellWithReuseIdentifier:kHotCellId];
    
    [_collectionView registerNib:[UINib nibWithNibName:@"AddCommodityCollectionViewCell" bundle:[NSBundle mainBundle]] forCellWithReuseIdentifier:kCellId];
    
    //header
    [_collectionView registerNib:[UINib nibWithNibName:@"AddCommodityHeaderCollectionReusableView" bundle:[NSBundle mainBundle]] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:kHeaderId];
    
    [_collectionView registerNib:[UINib nibWithNibName:@"AddCommodityFooterCollectionReusableView" bundle:[NSBundle mainBundle]] forSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:kFooterId];
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout referenceSizeForFooterInSection:(NSInteger)section {
    return CGSizeMake(kWidth, 30);
}

#pragma mark ==============collectionViewHeader==============
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout referenceSizeForHeaderInSection:(NSInteger)section {
    return CGSizeMake(ScreenSize.width, 44);
}

- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath {
    
    if (kind == UICollectionElementKindSectionHeader) {
        
        AddCommodityHeaderCollectionReusableView *reuseHeaderView = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:kHeaderId forIndexPath:indexPath];
        if (indexPath.section == 0) {
            [reuseHeaderView sectionHot];
        }else if(indexPath.section == 1){
            [reuseHeaderView sectionNormalWithTitle:@"标签"];
        }else{
            [reuseHeaderView sectionNormalWithTitle:@"分类"];
        }
        return reuseHeaderView;
        
    }else if (kind == UICollectionElementKindSectionFooter){
        
        AddCommodityFooterCollectionReusableView *reuseFooter = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:kFooterId forIndexPath:indexPath];
        
        
        return reuseFooter;
    }
    
    
    return nil;
    
    
}

#pragma mark ============== items ==============

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.section == 0) {
        return CGSizeMake((ScreenSize.width - kMargin * 2)/3, kAutoValue(100));
    }else{
        return CGSizeMake((ScreenSize.width - kMargin * 2)/4, kAutoValue(160));
    }
}

-(CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout minimumInteritemSpacingForSectionAtIndex:(NSInteger)section{
    
    //两个item的列间距
    
    return 0;
    
}
-(CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout minimumLineSpacingForSectionAtIndex:(NSInteger)section{
    
    //如果一组中有多行item，设置行间距
    
    return 0;
    
}

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView {
    return self.arrData.count;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    
    return section == 1 ? 4 : [self.arrData[section] count];
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    
    //热门品牌
    if (indexPath.section == 0) {
        HotCommodityCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:kHotCellId forIndexPath:indexPath];
        [cell cellWithModel:self.arrData[indexPath.section][indexPath.row] indexPath:indexPath];

        return cell;
        
    //标签
    }else if(indexPath.section == 1){
        AddCommodityCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:kCellId forIndexPath:indexPath];
        [cell cellWithHotTagsModel:self.arrData[indexPath.section][indexPath.row] indexPath:indexPath];
        
        return cell;
       
    //分类
    }else{
        AddCommodityCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:kCellId forIndexPath:indexPath];
        [cell cellWithModel:self.arrData[indexPath.section][indexPath.row] indexPath:indexPath];
        
        return cell;
        
    }
    return nil;
}


- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    CommodityListViewController *commodityVC = [[CommodityListViewController alloc] init];
    commodityVC.hidesBottomBarWhenPushed = YES;
    commodityVC.model = self.arrData[indexPath.section][indexPath.row];
    [self.navigationController pushViewController:commodityVC animated:YES];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
