//
//  OrderTableViewCell.m
//  ALand
//
//  Created by Z on 16/3/30.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "OrderTableViewCell.h"
#import "OrderCellView.h"

@interface OrderTableViewCell ()
@property (nonatomic, strong) NSMutableArray *arrCellView;
@property (weak, nonatomic) IBOutlet UILabel *labelState;

@end
@implementation OrderTableViewCell

- (void)awakeFromNib {
    // Initialization code
    self.arrCellView = [NSMutableArray array];
    self.selectionStyle = UITableViewCellSelectionStyleNone;
}

- (void)cellWithViewNumber:(NSInteger)number {
    for (OrderCellView *cellView  in self.arrCellView) {
        [cellView removeFromSuperview];
    }
    
        for (NSInteger i = 0; i < number; i++) {
            OrderCellView *cellView = [OrderCellView viewWithNibName:@"OrderCellView"];
            cellView.frame = CGRectMake(0, 74 + 120 * i, self.width, 120);

                [self.arrCellView addObject:cellView];
                [self.contentView addSubview:cellView];
        }

}

- (void)setState:(NSString *)orderState {
    self.labelState.text = orderState;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
