//
//  MoneyView.m
//  ALand
//
//  Created by Z on 16/3/22.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "MoneyView.h"

@interface MoneyView ()

@property (weak, nonatomic) IBOutlet UILabel *labelMoney;
@property (weak, nonatomic) IBOutlet UILabel *labelMonthIncome;
@property (weak, nonatomic) IBOutlet UILabel *labelMonthSale;
@property (weak, nonatomic) IBOutlet UILabel *labelMonthOrder;
@property (weak, nonatomic) IBOutlet UIButton *buttonEye;//tag为0，则显示星号，tag为1，显示金额
@property (nonatomic, copy) NSString *realMoney;
@end


@implementation MoneyView

- (void)awakeFromNib {
    WS(weakSelf)
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        NSString *str = [[NSUserDefaults standardUserDefaults] objectForKey:@"hideMoney"];
        
        if ([str isEqualToString:@"YES"]) {
            weakSelf.buttonEye.tag = 1;
            weakSelf.labelMoney.text = @"******";
            [self.buttonEye setImage:[UIImage imageNamed:@"Invisible_icon"] forState:UIControlStateNormal];
        }else{
            
        }
    });
}

- (IBAction)buttonEyeAction:(UIButton *)sender {
    if (sender.tag == 0) {
        self.labelMoney.text = @"******";
        sender.tag = 1;
        [sender setImage:[UIImage imageNamed:@"Invisible_icon"] forState:UIControlStateNormal];
        [[NSUserDefaults standardUserDefaults] setObject:@"YES" forKey:@"hideMoney"];
        
    }else{
        self.labelMoney.text = @"23421";
        sender.tag = 0;
        [sender setImage:[UIImage imageNamed:@"eyeOpen"] forState:UIControlStateNormal];
        [[NSUserDefaults standardUserDefaults] setObject:@"NO" forKey:@"hideMoney"];
    }
    
}

//设置总收入金额
- (void)setMondeyNumber:(NSString *)number{
    if (self.buttonEye.tag == 0) {
        
    }else{
        self.labelMoney.text = number;
    }
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
