//
//  CommodityTableViewCell.m
//  ALand
//
//  Created by Z on 16/3/29.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "CommodityTableViewCell.h"

@interface CommodityTableViewCell ()
@property (weak, nonatomic) IBOutlet UIImageView *imgViewCommodity;
@property (weak, nonatomic) IBOutlet UILabel *labelTitle;
@property (weak, nonatomic) IBOutlet UILabel *labelPrice;
@property (weak, nonatomic) IBOutlet UILabel *labelBrokerageRate;
@property (weak, nonatomic) IBOutlet UILabel *labelSaleNumber;

@end
@implementation CommodityTableViewCell

- (void)awakeFromNib {
    // Initialization code
}

- (void)cellWithModel:(CommotityListModel *)model
{
    [self.imgViewCommodity sd_setImageWithURL:[NSURL URLWithString:model.pictures] placeholderImage:kPlaceHolderImage];
    self.labelTitle.text = model.name;
    self.labelPrice.text = [NSString stringWithFormat:@"￥%.0f",model.price];
    self.labelBrokerageRate.text = [NSString stringWithFormat:@"%.2f",model.brokerageRate];
    
    
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
