//
//  CommodityListCollectionViewCell.m
//  ALand
//
//  Created by Z on 16/3/23.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "CommodityListCollectionViewCell.h"
#import "NSDate+FormatterAdditions.h"
#import "addCommodityRequestModel.h"
@interface CommodityListCollectionViewCell ()
@property (weak, nonatomic) IBOutlet UIImageView *imageViewTop;
@property (weak, nonatomic) IBOutlet UILabel *labelTitle;
@property (weak, nonatomic) IBOutlet UILabel *labelCommission;
@property (weak, nonatomic) IBOutlet UILabel *labelPrice;
@property (weak, nonatomic) IBOutlet UILabel *labelOriginalPrice;
@property (weak, nonatomic) IBOutlet UILabel *labelBrokerageRate;
@property (nonatomic, strong) CommotityListModel *model;

@end

@implementation CommodityListCollectionViewCell

- (void)cellWithModel:(CommotityListModel *)model {
    self.labelPrice.text = [NSString stringWithFormat:@"%.0f",model.price];
    [self.imageViewTop sd_setImageWithURL:[NSURL URLWithString:model.pictures] placeholderImage:kPlaceHolderImage];
    self.labelOriginalPrice.text = [NSString stringWithFormat:@"%.0f", model.originalPrice];
    self.labelBrokerageRate.text = [NSString stringWithFormat:@"%.2f", model.brokerageRate];
    self.labelTitle.text = model.name;
    self.model = model;
}
- (IBAction)actionAdd:(id)sender {
    CLog(@"添加商品");
    UserInfo *info = [UserInfo shareInstance];
    
    NSDictionary *param = @{
                            @"operCtx": @{
                                    @"time": [[NSDate date] timeStampNumber],
                                    @"domain": info.domain,
                                    @"operator": @{
                                            @"id": info.uuid,
                                            @"fullName": info.name
                                            }
                                    },
                            @"shopUuid": info.shop.uuid,
                            @"goodsUuid":self.model.uuid
                            };
    
    WS(weakSelf)
    [[HTTPCilent shareCilent] POST:@"shop/addGoods" parameters:param success:^(NSURLSessionDataTask *task, id responseObject) {
        if ([responseObject[@"code"] isEqualToNumber: @0]) {
            
            [weakSelf addSUccess];
            weakSelf.successBlock();
        }
    } failure:^(NSURLSessionDataTask *task, NSError *error) {
        
    }];
    
    
}


- (void)addSUccess {
    //添加成功提示框
    MBProgressHUD *hud = [[MBProgressHUD alloc] initWithView:self.window];
    [self.window addSubview:hud];
    hud.animationType = MBProgressHUDAnimationFade;
    hud.removeFromSuperViewOnHide = YES;
    hud.labelText = @"添加成功！";
    hud.mode = MBProgressHUDModeText;
    [hud show:YES];
    [hud hide:YES afterDelay:1];
}



- (void)awakeFromNib {
    // Initialization code
}

@end
