//
//  AddCommodityCollectionViewCell.m
//  ALand
//
//  Created by Z on 16/3/25.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "AddCommodityCollectionViewCell.h"

@interface AddCommodityCollectionViewCell ()
@property (weak, nonatomic) IBOutlet UIView *viewTopLine;
@property (weak, nonatomic) IBOutlet UIView *viewLeftLine;

@property (weak, nonatomic) IBOutlet UIView *viewRightLine;
@property (weak, nonatomic) IBOutlet UIImageView *imgView;
@property (weak, nonatomic) IBOutlet UILabel *labelTItle;
@property (weak, nonatomic) IBOutlet UILabel *labelDsc;

@end
@implementation AddCommodityCollectionViewCell

- (void)cellWithModel:(CatgoryModel *)model indexPath:(NSIndexPath *)indexPath {
    [self.imgView sd_setImageWithURL:[NSURL URLWithString:model.pictures] placeholderImage:kPlaceHolderImage];
    self.labelDsc.text = model.adescription;
    self.labelTItle.text = model.name;
    
    if ((int)indexPath.row / 4 == 0) {
        [self showTopLine];
    }else{
        [self hideTopLine];
    }
    
    if ((int)indexPath.row % 4 == 0) {
        [self showLeftLine];
    }else{
        [self hideLeftLine];
    }

}

- (void)cellWithHotTagsModel:(JavenHotTagsModel *)model indexPath:(NSIndexPath *)indexPath
{
    //[self.imgView sd_setImageWithURL:[NSURL URLWithString:model.pictures] placeholderImage:nil];
    //self.labelDsc.text = model.adescription;
    self.labelTItle.text = model.name;
    
    if ((int)indexPath.row / 4 == 0) {
        [self showTopLine];
    }else{
        [self hideTopLine];
    }
    
    if ((int)indexPath.row % 4 == 0) {
        [self showLeftLine];
    }else{
        [self hideLeftLine];
    }
}

- (void)hideTopLine {
    self.viewTopLine.hidden = YES;
}

- (void)hideRightLine {
    self.viewRightLine.hidden = YES;
}

- (void)showTopLine {
    self.viewTopLine.hidden = NO;
}
- (void)showRightLine {
    self.viewRightLine.hidden = NO;
}

- (void)hideLeftLine {
    self.viewLeftLine.hidden = YES;
}
- (void)showLeftLine {
    self.viewLeftLine.hidden = NO;
}

- (void)awakeFromNib {
    // Initialization code
}

@end
