//
//  JavenShopModel.m
//
//  Created by Z  on 16/4/14
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "JavenShopModel.h"
#import "JavenOwner.h"
#import "JavenLastModifyInfo.h"
#import "JavenCreateInfo.h"


NSString *const kJavenShopModelDays7Refund = @"days7Refund";
NSString *const kJavenShopModelCode = @"code";
NSString *const kJavenShopModelOwner = @"owner";
NSString *const kJavenShopModelUpper = @"upper";
NSString *const kJavenShopModelUuid = @"uuid";
NSString *const kJavenShopModelPath = @"path";
NSString *const kJavenShopModelLastModifyInfo = @"lastModifyInfo";
NSString *const kJavenShopModelContact = @"contact";
NSString *const kJavenShopModelVersion = @"version";
NSString *const kJavenShopModelFavorited = @"favorited";
NSString *const kJavenShopModelName = @"name";
NSString *const kJavenShopModelState = @"state";
NSString *const kJavenShopModelDomain = @"domain";
NSString *const kJavenShopModelRoles = @"roles";
NSString *const kJavenShopModelUpperOrgPath = @"upperOrgPath";
NSString *const kJavenShopModelGrade = @"grade";
NSString *const kJavenShopModelSiteDomain = @"siteDomain";
NSString *const kJavenShopModelPictures = @"pictures";
NSString *const kJavenShopModelCreateInfo = @"createInfo";
NSString *const kJavenShopModelOrder = @"order";
NSString *const kJavenShopModelDescription = @"description";


@interface JavenShopModel ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation JavenShopModel

@synthesize days7Refund = _days7Refund;
@synthesize code = _code;
@synthesize owner = _owner;
@synthesize upper = _upper;
@synthesize uuid = _uuid;
@synthesize path = _path;
@synthesize lastModifyInfo = _lastModifyInfo;
@synthesize contact = _contact;
@synthesize version = _version;
@synthesize favorited = _favorited;
@synthesize name = _name;
@synthesize state = _state;
@synthesize domain = _domain;
@synthesize roles = _roles;
@synthesize upperOrgPath = _upperOrgPath;
@synthesize grade = _grade;
@synthesize siteDomain = _siteDomain;
@synthesize pictures = _pictures;
@synthesize createInfo = _createInfo;
@synthesize order = _order;
@synthesize internalBaseClassDescription = _internalBaseClassDescription;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.days7Refund = [[self objectOrNilForKey:kJavenShopModelDays7Refund fromDictionary:dict] boolValue];
            self.code = [self objectOrNilForKey:kJavenShopModelCode fromDictionary:dict];
            self.owner = [JavenOwner modelObjectWithDictionary:[dict objectForKey:kJavenShopModelOwner]];
            self.upper = [self objectOrNilForKey:kJavenShopModelUpper fromDictionary:dict];
            self.uuid = [self objectOrNilForKey:kJavenShopModelUuid fromDictionary:dict];
            self.path = [self objectOrNilForKey:kJavenShopModelPath fromDictionary:dict];
            self.lastModifyInfo = [JavenLastModifyInfo modelObjectWithDictionary:[dict objectForKey:kJavenShopModelLastModifyInfo]];
            self.contact = [self objectOrNilForKey:kJavenShopModelContact fromDictionary:dict];
            self.version = [[self objectOrNilForKey:kJavenShopModelVersion fromDictionary:dict] doubleValue];
            self.favorited = [[self objectOrNilForKey:kJavenShopModelFavorited fromDictionary:dict] doubleValue];
            self.name = [self objectOrNilForKey:kJavenShopModelName fromDictionary:dict];
            self.state = [self objectOrNilForKey:kJavenShopModelState fromDictionary:dict];
            self.domain = [self objectOrNilForKey:kJavenShopModelDomain fromDictionary:dict];
            self.roles = [self objectOrNilForKey:kJavenShopModelRoles fromDictionary:dict];
            self.upperOrgPath = [self objectOrNilForKey:kJavenShopModelUpperOrgPath fromDictionary:dict];
            self.grade = [[self objectOrNilForKey:kJavenShopModelGrade fromDictionary:dict] doubleValue];
            self.siteDomain = [self objectOrNilForKey:kJavenShopModelSiteDomain fromDictionary:dict];
            self.pictures = [self objectOrNilForKey:kJavenShopModelPictures fromDictionary:dict];
            self.createInfo = [JavenCreateInfo modelObjectWithDictionary:[dict objectForKey:kJavenShopModelCreateInfo]];
            self.order = [[self objectOrNilForKey:kJavenShopModelOrder fromDictionary:dict] doubleValue];
            self.internalBaseClassDescription = [self objectOrNilForKey:kJavenShopModelDescription fromDictionary:dict];

    }
    
    return self;
    
}


- (instancetype)updateWithDictionary:(NSDictionary *)dict
{
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
        self.days7Refund = [[self objectOrNilForKey:kJavenShopModelDays7Refund fromDictionary:dict] boolValue];
        self.code = [self objectOrNilForKey:kJavenShopModelCode fromDictionary:dict];
        self.owner = [JavenOwner modelObjectWithDictionary:[dict objectForKey:kJavenShopModelOwner]];
        self.upper = [self objectOrNilForKey:kJavenShopModelUpper fromDictionary:dict];
        self.uuid = [self objectOrNilForKey:kJavenShopModelUuid fromDictionary:dict];
        self.path = [self objectOrNilForKey:kJavenShopModelPath fromDictionary:dict];
        self.lastModifyInfo = [JavenLastModifyInfo modelObjectWithDictionary:[dict objectForKey:kJavenShopModelLastModifyInfo]];
        self.contact = [self objectOrNilForKey:kJavenShopModelContact fromDictionary:dict];
        self.version = [[self objectOrNilForKey:kJavenShopModelVersion fromDictionary:dict] doubleValue];
        self.favorited = [[self objectOrNilForKey:kJavenShopModelFavorited fromDictionary:dict] doubleValue];
        self.name = [self objectOrNilForKey:kJavenShopModelName fromDictionary:dict];
        self.state = [self objectOrNilForKey:kJavenShopModelState fromDictionary:dict];
        self.domain = [self objectOrNilForKey:kJavenShopModelDomain fromDictionary:dict];
        self.roles = [self objectOrNilForKey:kJavenShopModelRoles fromDictionary:dict];
        self.upperOrgPath = [self objectOrNilForKey:kJavenShopModelUpperOrgPath fromDictionary:dict];
        self.grade = [[self objectOrNilForKey:kJavenShopModelGrade fromDictionary:dict] doubleValue];
        self.siteDomain = [self objectOrNilForKey:kJavenShopModelSiteDomain fromDictionary:dict];
        self.pictures = [self objectOrNilForKey:kJavenShopModelPictures fromDictionary:dict];
        self.createInfo = [JavenCreateInfo modelObjectWithDictionary:[dict objectForKey:kJavenShopModelCreateInfo]];
        self.order = [[self objectOrNilForKey:kJavenShopModelOrder fromDictionary:dict] doubleValue];
        self.internalBaseClassDescription = [self objectOrNilForKey:kJavenShopModelDescription fromDictionary:dict];
        
    }
    
    return self;
   
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[NSNumber numberWithBool:self.days7Refund] forKey:kJavenShopModelDays7Refund];
    [mutableDict setValue:self.code forKey:kJavenShopModelCode];
    [mutableDict setValue:[self.owner dictionaryRepresentation] forKey:kJavenShopModelOwner];
    [mutableDict setValue:self.upper forKey:kJavenShopModelUpper];
    [mutableDict setValue:self.uuid forKey:kJavenShopModelUuid];
    [mutableDict setValue:self.path forKey:kJavenShopModelPath];
    [mutableDict setValue:[self.lastModifyInfo dictionaryRepresentation] forKey:kJavenShopModelLastModifyInfo];
    [mutableDict setValue:self.contact forKey:kJavenShopModelContact];
    [mutableDict setValue:[NSNumber numberWithDouble:self.version] forKey:kJavenShopModelVersion];
    [mutableDict setValue:[NSNumber numberWithDouble:self.favorited] forKey:kJavenShopModelFavorited];
    [mutableDict setValue:self.name forKey:kJavenShopModelName];
    [mutableDict setValue:self.state forKey:kJavenShopModelState];
    [mutableDict setValue:self.domain forKey:kJavenShopModelDomain];
    NSMutableArray *tempArrayForRoles = [NSMutableArray array];
    for (NSObject *subArrayObject in self.roles) {
        if([subArrayObject respondsToSelector:@selector(dictionaryRepresentation)]) {
            // This class is a model object
            [tempArrayForRoles addObject:[subArrayObject performSelector:@selector(dictionaryRepresentation)]];
        } else {
            // Generic object
            [tempArrayForRoles addObject:subArrayObject];
        }
    }
    [mutableDict setValue:[NSArray arrayWithArray:tempArrayForRoles] forKey:kJavenShopModelRoles];
    [mutableDict setValue:self.upperOrgPath forKey:kJavenShopModelUpperOrgPath];
    [mutableDict setValue:[NSNumber numberWithDouble:self.grade] forKey:kJavenShopModelGrade];
    [mutableDict setValue:self.siteDomain forKey:kJavenShopModelSiteDomain];
    [mutableDict setValue:self.pictures forKey:kJavenShopModelPictures];
    [mutableDict setValue:[self.createInfo dictionaryRepresentation] forKey:kJavenShopModelCreateInfo];
    [mutableDict setValue:[NSNumber numberWithDouble:self.order] forKey:kJavenShopModelOrder];
    [mutableDict setValue:self.internalBaseClassDescription forKey:kJavenShopModelDescription];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.days7Refund = [aDecoder decodeBoolForKey:kJavenShopModelDays7Refund];
    self.code = [aDecoder decodeObjectForKey:kJavenShopModelCode];
    self.owner = [aDecoder decodeObjectForKey:kJavenShopModelOwner];
    self.upper = [aDecoder decodeObjectForKey:kJavenShopModelUpper];
    self.uuid = [aDecoder decodeObjectForKey:kJavenShopModelUuid];
    self.path = [aDecoder decodeObjectForKey:kJavenShopModelPath];
    self.lastModifyInfo = [aDecoder decodeObjectForKey:kJavenShopModelLastModifyInfo];
    self.contact = [aDecoder decodeObjectForKey:kJavenShopModelContact];
    self.version = [aDecoder decodeDoubleForKey:kJavenShopModelVersion];
    self.favorited = [aDecoder decodeDoubleForKey:kJavenShopModelFavorited];
    self.name = [aDecoder decodeObjectForKey:kJavenShopModelName];
    self.state = [aDecoder decodeObjectForKey:kJavenShopModelState];
    self.domain = [aDecoder decodeObjectForKey:kJavenShopModelDomain];
    self.roles = [aDecoder decodeObjectForKey:kJavenShopModelRoles];
    self.upperOrgPath = [aDecoder decodeObjectForKey:kJavenShopModelUpperOrgPath];
    self.grade = [aDecoder decodeDoubleForKey:kJavenShopModelGrade];
    self.siteDomain = [aDecoder decodeObjectForKey:kJavenShopModelSiteDomain];
    self.pictures = [aDecoder decodeObjectForKey:kJavenShopModelPictures];
    self.createInfo = [aDecoder decodeObjectForKey:kJavenShopModelCreateInfo];
    self.order = [aDecoder decodeDoubleForKey:kJavenShopModelOrder];
    self.internalBaseClassDescription = [aDecoder decodeObjectForKey:kJavenShopModelDescription];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeBool:_days7Refund forKey:kJavenShopModelDays7Refund];
    [aCoder encodeObject:_code forKey:kJavenShopModelCode];
    [aCoder encodeObject:_owner forKey:kJavenShopModelOwner];
    [aCoder encodeObject:_upper forKey:kJavenShopModelUpper];
    [aCoder encodeObject:_uuid forKey:kJavenShopModelUuid];
    [aCoder encodeObject:_path forKey:kJavenShopModelPath];
    [aCoder encodeObject:_lastModifyInfo forKey:kJavenShopModelLastModifyInfo];
    [aCoder encodeObject:_contact forKey:kJavenShopModelContact];
    [aCoder encodeDouble:_version forKey:kJavenShopModelVersion];
    [aCoder encodeDouble:_favorited forKey:kJavenShopModelFavorited];
    [aCoder encodeObject:_name forKey:kJavenShopModelName];
    [aCoder encodeObject:_state forKey:kJavenShopModelState];
    [aCoder encodeObject:_domain forKey:kJavenShopModelDomain];
    [aCoder encodeObject:_roles forKey:kJavenShopModelRoles];
    [aCoder encodeObject:_upperOrgPath forKey:kJavenShopModelUpperOrgPath];
    [aCoder encodeDouble:_grade forKey:kJavenShopModelGrade];
    [aCoder encodeObject:_siteDomain forKey:kJavenShopModelSiteDomain];
    [aCoder encodeObject:_pictures forKey:kJavenShopModelPictures];
    [aCoder encodeObject:_createInfo forKey:kJavenShopModelCreateInfo];
    [aCoder encodeDouble:_order forKey:kJavenShopModelOrder];
    [aCoder encodeObject:_internalBaseClassDescription forKey:kJavenShopModelDescription];
}

- (id)copyWithZone:(NSZone *)zone
{
    JavenShopModel *copy = [[JavenShopModel alloc] init];
    
    if (copy) {

        copy.days7Refund = self.days7Refund;
        copy.code = [self.code copyWithZone:zone];
        copy.owner = [self.owner copyWithZone:zone];
        copy.upper = [self.upper copyWithZone:zone];
        copy.uuid = [self.uuid copyWithZone:zone];
        copy.path = [self.path copyWithZone:zone];
        copy.lastModifyInfo = [self.lastModifyInfo copyWithZone:zone];
        copy.contact = [self.contact copyWithZone:zone];
        copy.version = self.version;
        copy.favorited = self.favorited;
        copy.name = [self.name copyWithZone:zone];
        copy.state = [self.state copyWithZone:zone];
        copy.domain = [self.domain copyWithZone:zone];
        copy.roles = [self.roles copyWithZone:zone];
        copy.upperOrgPath = [self.upperOrgPath copyWithZone:zone];
        copy.grade = self.grade;
        copy.siteDomain = [self.siteDomain copyWithZone:zone];
        copy.pictures = [self.pictures copyWithZone:zone];
        copy.createInfo = [self.createInfo copyWithZone:zone];
        copy.order = self.order;
        copy.internalBaseClassDescription = [self.internalBaseClassDescription copyWithZone:zone];
    }
    
    return copy;
}


@end
