//
//  JavenShopModel.h
//
//  Created by Z  on 16/4/14
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class JavenOwner, JavenLastModifyInfo, JavenCreateInfo;

@interface JavenShopModel : NSObject <NSCoding, NSCopying>

@property (nonatomic, assign) BOOL days7Refund;
@property (nonatomic, strong) NSString *code;
@property (nonatomic, strong) JavenOwner *owner;
@property (nonatomic, assign) id upper;
@property (nonatomic, strong) NSString *uuid;
@property (nonatomic, strong) NSString *path;
@property (nonatomic, strong) JavenLastModifyInfo *lastModifyInfo;
@property (nonatomic, assign) id contact;
@property (nonatomic, assign) double version;
@property (nonatomic, assign) double favorited;
@property (nonatomic, strong) NSString *name;
@property (nonatomic, strong) NSString *state;
@property (nonatomic, strong) NSString *domain;
@property (nonatomic, strong) NSArray *roles;
@property (nonatomic, assign) id upperOrgPath;
@property (nonatomic, assign) double grade;
@property (nonatomic, assign) id siteDomain;
@property (nonatomic, strong) NSString *pictures;
@property (nonatomic, strong) JavenCreateInfo *createInfo;
@property (nonatomic, assign) double order;
@property (nonatomic, copy) NSString *internalBaseClassDescription;

+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict;
- (instancetype)initWithDictionary:(NSDictionary *)dict;
- (instancetype)updateWithDictionary:(NSDictionary *)dict;

- (NSDictionary *)dictionaryRepresentation;

@end
