//
//  JavenHotTagsModel.m
//
//  Created by Z  on 16/4/12
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "JavenHotTagsModel.h"
#import "JavenCategory.h"
#import "JavenLastModifyInfo.h"
#import "JavenCreateInfo.h"


NSString *const kJavenHotTagsModelDomain = @"domain";
NSString *const kJavenHotTagsModelCategory = @"category";
NSString *const kJavenHotTagsModelLastModifyInfo = @"lastModifyInfo";
NSString *const kJavenHotTagsModelOrder = @"order";
NSString *const kJavenHotTagsModelUuid = @"uuid";
NSString *const kJavenHotTagsModelCreateInfo = @"createInfo";
NSString *const kJavenHotTagsModelVersion = @"version";
NSString *const kJavenHotTagsModelDescription = @"description";
NSString *const kJavenHotTagsModelName = @"name";


@interface JavenHotTagsModel ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation JavenHotTagsModel

@synthesize domain = _domain;
@synthesize category = _category;
@synthesize lastModifyInfo = _lastModifyInfo;
@synthesize order = _order;
@synthesize uuid = _uuid;
@synthesize createInfo = _createInfo;
@synthesize version = _version;
@synthesize internalBaseClassDescription = _internalBaseClassDescription;
@synthesize name = _name;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.domain = [self objectOrNilForKey:kJavenHotTagsModelDomain fromDictionary:dict];
            self.category = [JavenCategory modelObjectWithDictionary:[dict objectForKey:kJavenHotTagsModelCategory]];
            self.lastModifyInfo = [JavenLastModifyInfo modelObjectWithDictionary:[dict objectForKey:kJavenHotTagsModelLastModifyInfo]];
            self.order = [[self objectOrNilForKey:kJavenHotTagsModelOrder fromDictionary:dict] doubleValue];
            self.uuid = [self objectOrNilForKey:kJavenHotTagsModelUuid fromDictionary:dict];
            self.createInfo = [JavenCreateInfo modelObjectWithDictionary:[dict objectForKey:kJavenHotTagsModelCreateInfo]];
            self.version = [[self objectOrNilForKey:kJavenHotTagsModelVersion fromDictionary:dict] doubleValue];
            self.internalBaseClassDescription = [self objectOrNilForKey:kJavenHotTagsModelDescription fromDictionary:dict];
            self.name = [self objectOrNilForKey:kJavenHotTagsModelName fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.domain forKey:kJavenHotTagsModelDomain];
    [mutableDict setValue:[self.category dictionaryRepresentation] forKey:kJavenHotTagsModelCategory];
    [mutableDict setValue:[self.lastModifyInfo dictionaryRepresentation] forKey:kJavenHotTagsModelLastModifyInfo];
    [mutableDict setValue:[NSNumber numberWithDouble:self.order] forKey:kJavenHotTagsModelOrder];
    [mutableDict setValue:self.uuid forKey:kJavenHotTagsModelUuid];
    [mutableDict setValue:[self.createInfo dictionaryRepresentation] forKey:kJavenHotTagsModelCreateInfo];
    [mutableDict setValue:[NSNumber numberWithDouble:self.version] forKey:kJavenHotTagsModelVersion];
    [mutableDict setValue:self.internalBaseClassDescription forKey:kJavenHotTagsModelDescription];
    [mutableDict setValue:self.name forKey:kJavenHotTagsModelName];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.domain = [aDecoder decodeObjectForKey:kJavenHotTagsModelDomain];
    self.category = [aDecoder decodeObjectForKey:kJavenHotTagsModelCategory];
    self.lastModifyInfo = [aDecoder decodeObjectForKey:kJavenHotTagsModelLastModifyInfo];
    self.order = [aDecoder decodeDoubleForKey:kJavenHotTagsModelOrder];
    self.uuid = [aDecoder decodeObjectForKey:kJavenHotTagsModelUuid];
    self.createInfo = [aDecoder decodeObjectForKey:kJavenHotTagsModelCreateInfo];
    self.version = [aDecoder decodeDoubleForKey:kJavenHotTagsModelVersion];
    self.internalBaseClassDescription = [aDecoder decodeObjectForKey:kJavenHotTagsModelDescription];
    self.name = [aDecoder decodeObjectForKey:kJavenHotTagsModelName];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_domain forKey:kJavenHotTagsModelDomain];
    [aCoder encodeObject:_category forKey:kJavenHotTagsModelCategory];
    [aCoder encodeObject:_lastModifyInfo forKey:kJavenHotTagsModelLastModifyInfo];
    [aCoder encodeDouble:_order forKey:kJavenHotTagsModelOrder];
    [aCoder encodeObject:_uuid forKey:kJavenHotTagsModelUuid];
    [aCoder encodeObject:_createInfo forKey:kJavenHotTagsModelCreateInfo];
    [aCoder encodeDouble:_version forKey:kJavenHotTagsModelVersion];
    [aCoder encodeObject:_internalBaseClassDescription forKey:kJavenHotTagsModelDescription];
    [aCoder encodeObject:_name forKey:kJavenHotTagsModelName];
}

- (id)copyWithZone:(NSZone *)zone
{
    JavenHotTagsModel *copy = [[JavenHotTagsModel alloc] init];
    
    if (copy) {

        copy.domain = [self.domain copyWithZone:zone];
        copy.category = [self.category copyWithZone:zone];
        copy.lastModifyInfo = [self.lastModifyInfo copyWithZone:zone];
        copy.order = self.order;
        copy.uuid = [self.uuid copyWithZone:zone];
        copy.createInfo = [self.createInfo copyWithZone:zone];
        copy.version = self.version;
        copy.internalBaseClassDescription = [self.internalBaseClassDescription copyWithZone:zone];
        copy.name = [self.name copyWithZone:zone];
    }
    
    return copy;
}


@end
