//
//  CommotityListUpper.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "CommotityListUpper.h"


NSString *const kCommotityListUpperName = @"name";
NSString *const kCommotityListUpperCode = @"code";
NSString *const kCommotityListUpperUuid = @"uuid";


@interface CommotityListUpper ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation CommotityListUpper

@synthesize name = _name;
@synthesize code = _code;
@synthesize uuid = _uuid;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.name = [self objectOrNilForKey:kCommotityListUpperName fromDictionary:dict];
            self.code = [self objectOrNilForKey:kCommotityListUpperCode fromDictionary:dict];
            self.uuid = [self objectOrNilForKey:kCommotityListUpperUuid fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.name forKey:kCommotityListUpperName];
    [mutableDict setValue:self.code forKey:kCommotityListUpperCode];
    [mutableDict setValue:self.uuid forKey:kCommotityListUpperUuid];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.name = [aDecoder decodeObjectForKey:kCommotityListUpperName];
    self.code = [aDecoder decodeObjectForKey:kCommotityListUpperCode];
    self.uuid = [aDecoder decodeObjectForKey:kCommotityListUpperUuid];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_name forKey:kCommotityListUpperName];
    [aCoder encodeObject:_code forKey:kCommotityListUpperCode];
    [aCoder encodeObject:_uuid forKey:kCommotityListUpperUuid];
}

- (id)copyWithZone:(NSZone *)zone
{
    CommotityListUpper *copy = [[CommotityListUpper alloc] init];
    
    if (copy) {

        copy.name = [self.name copyWithZone:zone];
        copy.code = [self.code copyWithZone:zone];
        copy.uuid = [self.uuid copyWithZone:zone];
    }
    
    return copy;
}


@end
