//
//  CommotityListOperator.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "CommotityListOperator.h"


NSString *const kCommotityListOperatorId = @"id";
NSString *const kCommotityListOperatorFullName = @"fullName";


@interface CommotityListOperator ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation CommotityListOperator

@synthesize operatorIdentifier = _operatorIdentifier;
@synthesize fullName = _fullName;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.operatorIdentifier = [self objectOrNilForKey:kCommotityListOperatorId fromDictionary:dict];
            self.fullName = [self objectOrNilForKey:kCommotityListOperatorFullName fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.operatorIdentifier forKey:kCommotityListOperatorId];
    [mutableDict setValue:self.fullName forKey:kCommotityListOperatorFullName];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.operatorIdentifier = [aDecoder decodeObjectForKey:kCommotityListOperatorId];
    self.fullName = [aDecoder decodeObjectForKey:kCommotityListOperatorFullName];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_operatorIdentifier forKey:kCommotityListOperatorId];
    [aCoder encodeObject:_fullName forKey:kCommotityListOperatorFullName];
}

- (id)copyWithZone:(NSZone *)zone
{
    CommotityListOperator *copy = [[CommotityListOperator alloc] init];
    
    if (copy) {

        copy.operatorIdentifier = [self.operatorIdentifier copyWithZone:zone];
        copy.fullName = [self.fullName copyWithZone:zone];
    }
    
    return copy;
}


@end
