//
//  CommotityListModel.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "CommotityListModel.h"
#import "CommotityListCategory.h"
#import "CommotityListBrand.h"


NSString *const kCommotityListModelCategory = @"category";
NSString *const kCommotityListModelBrokerageRate = @"brokerageRate";
NSString *const kCommotityListModelOriginalPrice = @"originalPrice";
NSString *const kCommotityListModelInv = @"inv";
NSString *const kCommotityListModelPrice = @"price";
NSString *const kCommotityListModelUuid = @"uuid";
NSString *const kCommotityListModelEngName = @"engName";
NSString *const kCommotityListModelBrand = @"brand";
NSString *const kCommotityListModelPictures = @"pictures";
NSString *const kCommotityListModelName = @"name";
NSString *const kCommotityListModelTranferType = @"tranferType";


@interface CommotityListModel ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation CommotityListModel

@synthesize category = _category;
@synthesize brokerageRate = _brokerageRate;
@synthesize originalPrice = _originalPrice;
@synthesize inv = _inv;
@synthesize price = _price;
@synthesize uuid = _uuid;
@synthesize engName = _engName;
@synthesize brand = _brand;
@synthesize pictures = _pictures;
@synthesize name = _name;
@synthesize tranferType = _tranferType;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.category = [CommotityListCategory modelObjectWithDictionary:[dict objectForKey:kCommotityListModelCategory]];
            self.brokerageRate = [[self objectOrNilForKey:kCommotityListModelBrokerageRate fromDictionary:dict] doubleValue];
            self.originalPrice = [[self objectOrNilForKey:kCommotityListModelOriginalPrice fromDictionary:dict] doubleValue];
            self.inv = [[self objectOrNilForKey:kCommotityListModelInv fromDictionary:dict] doubleValue];
            self.price = [[self objectOrNilForKey:kCommotityListModelPrice fromDictionary:dict] doubleValue];
            self.uuid = [self objectOrNilForKey:kCommotityListModelUuid fromDictionary:dict];
            self.engName = [self objectOrNilForKey:kCommotityListModelEngName fromDictionary:dict];
            self.brand = [CommotityListBrand modelObjectWithDictionary:[dict objectForKey:kCommotityListModelBrand]];
            self.pictures = [self objectOrNilForKey:kCommotityListModelPictures fromDictionary:dict];
            self.name = [self objectOrNilForKey:kCommotityListModelName fromDictionary:dict];
            self.tranferType = [self objectOrNilForKey:kCommotityListModelTranferType fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[self.category dictionaryRepresentation] forKey:kCommotityListModelCategory];
    [mutableDict setValue:[NSNumber numberWithDouble:self.brokerageRate] forKey:kCommotityListModelBrokerageRate];
    [mutableDict setValue:[NSNumber numberWithDouble:self.originalPrice] forKey:kCommotityListModelOriginalPrice];
    [mutableDict setValue:[NSNumber numberWithDouble:self.inv] forKey:kCommotityListModelInv];
    [mutableDict setValue:[NSNumber numberWithDouble:self.price] forKey:kCommotityListModelPrice];
    [mutableDict setValue:self.uuid forKey:kCommotityListModelUuid];
    [mutableDict setValue:self.engName forKey:kCommotityListModelEngName];
    [mutableDict setValue:[self.brand dictionaryRepresentation] forKey:kCommotityListModelBrand];
    [mutableDict setValue:self.pictures forKey:kCommotityListModelPictures];
    [mutableDict setValue:self.name forKey:kCommotityListModelName];
    [mutableDict setValue:self.tranferType forKey:kCommotityListModelTranferType];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.category = [aDecoder decodeObjectForKey:kCommotityListModelCategory];
    self.brokerageRate = [aDecoder decodeDoubleForKey:kCommotityListModelBrokerageRate];
    self.originalPrice = [aDecoder decodeDoubleForKey:kCommotityListModelOriginalPrice];
    self.inv = [aDecoder decodeDoubleForKey:kCommotityListModelInv];
    self.price = [aDecoder decodeDoubleForKey:kCommotityListModelPrice];
    self.uuid = [aDecoder decodeObjectForKey:kCommotityListModelUuid];
    self.engName = [aDecoder decodeObjectForKey:kCommotityListModelEngName];
    self.brand = [aDecoder decodeObjectForKey:kCommotityListModelBrand];
    self.pictures = [aDecoder decodeObjectForKey:kCommotityListModelPictures];
    self.name = [aDecoder decodeObjectForKey:kCommotityListModelName];
    self.tranferType = [aDecoder decodeObjectForKey:kCommotityListModelTranferType];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_category forKey:kCommotityListModelCategory];
    [aCoder encodeDouble:_brokerageRate forKey:kCommotityListModelBrokerageRate];
    [aCoder encodeDouble:_originalPrice forKey:kCommotityListModelOriginalPrice];
    [aCoder encodeDouble:_inv forKey:kCommotityListModelInv];
    [aCoder encodeDouble:_price forKey:kCommotityListModelPrice];
    [aCoder encodeObject:_uuid forKey:kCommotityListModelUuid];
    [aCoder encodeObject:_engName forKey:kCommotityListModelEngName];
    [aCoder encodeObject:_brand forKey:kCommotityListModelBrand];
    [aCoder encodeObject:_pictures forKey:kCommotityListModelPictures];
    [aCoder encodeObject:_name forKey:kCommotityListModelName];
    [aCoder encodeObject:_tranferType forKey:kCommotityListModelTranferType];
}

- (id)copyWithZone:(NSZone *)zone
{
    CommotityListModel *copy = [[CommotityListModel alloc] init];
    
    if (copy) {

        copy.category = [self.category copyWithZone:zone];
        copy.brokerageRate = self.brokerageRate;
        copy.originalPrice = self.originalPrice;
        copy.inv = self.inv;
        copy.price = self.price;
        copy.uuid = [self.uuid copyWithZone:zone];
        copy.engName = [self.engName copyWithZone:zone];
        copy.brand = [self.brand copyWithZone:zone];
        copy.pictures = [self.pictures copyWithZone:zone];
        copy.name = [self.name copyWithZone:zone];
        copy.tranferType = [self.tranferType copyWithZone:zone];
    }
    
    return copy;
}


@end
