//
//  CommotityListLastModifyInfo.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "CommotityListLastModifyInfo.h"
#import "CommotityListOperator.h"


NSString *const kCommotityListLastModifyInfoOperator = @"operator";
NSString *const kCommotityListLastModifyInfoTime = @"time";


@interface CommotityListLastModifyInfo ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation CommotityListLastModifyInfo

@synthesize operator = _operator;
@synthesize time = _time;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.operator = [CommotityListOperator modelObjectWithDictionary:[dict objectForKey:kCommotityListLastModifyInfoOperator]];
            self.time = [[self objectOrNilForKey:kCommotityListLastModifyInfoTime fromDictionary:dict] doubleValue];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[self.operator dictionaryRepresentation] forKey:kCommotityListLastModifyInfoOperator];
    [mutableDict setValue:[NSNumber numberWithDouble:self.time] forKey:kCommotityListLastModifyInfoTime];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.operator = [aDecoder decodeObjectForKey:kCommotityListLastModifyInfoOperator];
    self.time = [aDecoder decodeDoubleForKey:kCommotityListLastModifyInfoTime];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_operator forKey:kCommotityListLastModifyInfoOperator];
    [aCoder encodeDouble:_time forKey:kCommotityListLastModifyInfoTime];
}

- (id)copyWithZone:(NSZone *)zone
{
    CommotityListLastModifyInfo *copy = [[CommotityListLastModifyInfo alloc] init];
    
    if (copy) {

        copy.operator = [self.operator copyWithZone:zone];
        copy.time = self.time;
    }
    
    return copy;
}


@end
