//
//  CommotityListCreateInfo.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "CommotityListCreateInfo.h"
#import "CommotityListOperator.h"


NSString *const kCommotityListCreateInfoOperator = @"operator";
NSString *const kCommotityListCreateInfoTime = @"time";


@interface CommotityListCreateInfo ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation CommotityListCreateInfo

@synthesize operator = _operator;
@synthesize time = _time;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.operator = [CommotityListOperator modelObjectWithDictionary:[dict objectForKey:kCommotityListCreateInfoOperator]];
            self.time = [[self objectOrNilForKey:kCommotityListCreateInfoTime fromDictionary:dict] doubleValue];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:[self.operator dictionaryRepresentation] forKey:kCommotityListCreateInfoOperator];
    [mutableDict setValue:[NSNumber numberWithDouble:self.time] forKey:kCommotityListCreateInfoTime];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.operator = [aDecoder decodeObjectForKey:kCommotityListCreateInfoOperator];
    self.time = [aDecoder decodeDoubleForKey:kCommotityListCreateInfoTime];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_operator forKey:kCommotityListCreateInfoOperator];
    [aCoder encodeDouble:_time forKey:kCommotityListCreateInfoTime];
}

- (id)copyWithZone:(NSZone *)zone
{
    CommotityListCreateInfo *copy = [[CommotityListCreateInfo alloc] init];
    
    if (copy) {

        copy.operator = [self.operator copyWithZone:zone];
        copy.time = self.time;
    }
    
    return copy;
}


@end
