//
//  CommotityListCategory.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "CommotityListCategory.h"
#import "CommotityListUpper.h"
#import "CommotityListLastModifyInfo.h"
#import "CommotityListCreateInfo.h"


NSString *const kCommotityListCategoryUuid = @"uuid";
NSString *const kCommotityListCategoryDescription = @"description";
NSString *const kCommotityListCategoryState = @"state";
NSString *const kCommotityListCategoryVersion = @"version";
NSString *const kCommotityListCategoryUpper = @"upper";
NSString *const kCommotityListCategoryDomain = @"domain";
NSString *const kCommotityListCategoryPath = @"path";
NSString *const kCommotityListCategoryLastModifyInfo = @"lastModifyInfo";
NSString *const kCommotityListCategoryCode = @"code";
NSString *const kCommotityListCategoryOrder = @"order";
NSString *const kCommotityListCategoryLevel = @"level";
NSString *const kCommotityListCategoryPictures = @"pictures";
NSString *const kCommotityListCategoryCreateInfo = @"createInfo";
NSString *const kCommotityListCategoryName = @"name";


@interface CommotityListCategory ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation CommotityListCategory

@synthesize uuid = _uuid;
@synthesize categoryDescription = _categoryDescription;
@synthesize state = _state;
@synthesize version = _version;
@synthesize upper = _upper;
@synthesize domain = _domain;
@synthesize path = _path;
@synthesize lastModifyInfo = _lastModifyInfo;
@synthesize code = _code;
@synthesize order = _order;
@synthesize level = _level;
@synthesize pictures = _pictures;
@synthesize createInfo = _createInfo;
@synthesize name = _name;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.uuid = [self objectOrNilForKey:kCommotityListCategoryUuid fromDictionary:dict];
            self.categoryDescription = [self objectOrNilForKey:kCommotityListCategoryDescription fromDictionary:dict];
            self.state = [self objectOrNilForKey:kCommotityListCategoryState fromDictionary:dict];
            self.version = [[self objectOrNilForKey:kCommotityListCategoryVersion fromDictionary:dict] doubleValue];
            self.upper = [CommotityListUpper modelObjectWithDictionary:[dict objectForKey:kCommotityListCategoryUpper]];
            self.domain = [self objectOrNilForKey:kCommotityListCategoryDomain fromDictionary:dict];
            self.path = [self objectOrNilForKey:kCommotityListCategoryPath fromDictionary:dict];
            self.lastModifyInfo = [CommotityListLastModifyInfo modelObjectWithDictionary:[dict objectForKey:kCommotityListCategoryLastModifyInfo]];
            self.code = [self objectOrNilForKey:kCommotityListCategoryCode fromDictionary:dict];
            self.order = [[self objectOrNilForKey:kCommotityListCategoryOrder fromDictionary:dict] doubleValue];
            self.level = [[self objectOrNilForKey:kCommotityListCategoryLevel fromDictionary:dict] doubleValue];
            self.pictures = [self objectOrNilForKey:kCommotityListCategoryPictures fromDictionary:dict];
            self.createInfo = [CommotityListCreateInfo modelObjectWithDictionary:[dict objectForKey:kCommotityListCategoryCreateInfo]];
            self.name = [self objectOrNilForKey:kCommotityListCategoryName fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.uuid forKey:kCommotityListCategoryUuid];
    [mutableDict setValue:self.categoryDescription forKey:kCommotityListCategoryDescription];
    [mutableDict setValue:self.state forKey:kCommotityListCategoryState];
    [mutableDict setValue:[NSNumber numberWithDouble:self.version] forKey:kCommotityListCategoryVersion];
    [mutableDict setValue:[self.upper dictionaryRepresentation] forKey:kCommotityListCategoryUpper];
    [mutableDict setValue:self.domain forKey:kCommotityListCategoryDomain];
    [mutableDict setValue:self.path forKey:kCommotityListCategoryPath];
    [mutableDict setValue:[self.lastModifyInfo dictionaryRepresentation] forKey:kCommotityListCategoryLastModifyInfo];
    [mutableDict setValue:self.code forKey:kCommotityListCategoryCode];
    [mutableDict setValue:[NSNumber numberWithDouble:self.order] forKey:kCommotityListCategoryOrder];
    [mutableDict setValue:[NSNumber numberWithDouble:self.level] forKey:kCommotityListCategoryLevel];
    [mutableDict setValue:self.pictures forKey:kCommotityListCategoryPictures];
    [mutableDict setValue:[self.createInfo dictionaryRepresentation] forKey:kCommotityListCategoryCreateInfo];
    [mutableDict setValue:self.name forKey:kCommotityListCategoryName];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.uuid = [aDecoder decodeObjectForKey:kCommotityListCategoryUuid];
    self.categoryDescription = [aDecoder decodeObjectForKey:kCommotityListCategoryDescription];
    self.state = [aDecoder decodeObjectForKey:kCommotityListCategoryState];
    self.version = [aDecoder decodeDoubleForKey:kCommotityListCategoryVersion];
    self.upper = [aDecoder decodeObjectForKey:kCommotityListCategoryUpper];
    self.domain = [aDecoder decodeObjectForKey:kCommotityListCategoryDomain];
    self.path = [aDecoder decodeObjectForKey:kCommotityListCategoryPath];
    self.lastModifyInfo = [aDecoder decodeObjectForKey:kCommotityListCategoryLastModifyInfo];
    self.code = [aDecoder decodeObjectForKey:kCommotityListCategoryCode];
    self.order = [aDecoder decodeDoubleForKey:kCommotityListCategoryOrder];
    self.level = [aDecoder decodeDoubleForKey:kCommotityListCategoryLevel];
    self.pictures = [aDecoder decodeObjectForKey:kCommotityListCategoryPictures];
    self.createInfo = [aDecoder decodeObjectForKey:kCommotityListCategoryCreateInfo];
    self.name = [aDecoder decodeObjectForKey:kCommotityListCategoryName];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_uuid forKey:kCommotityListCategoryUuid];
    [aCoder encodeObject:_categoryDescription forKey:kCommotityListCategoryDescription];
    [aCoder encodeObject:_state forKey:kCommotityListCategoryState];
    [aCoder encodeDouble:_version forKey:kCommotityListCategoryVersion];
    [aCoder encodeObject:_upper forKey:kCommotityListCategoryUpper];
    [aCoder encodeObject:_domain forKey:kCommotityListCategoryDomain];
    [aCoder encodeObject:_path forKey:kCommotityListCategoryPath];
    [aCoder encodeObject:_lastModifyInfo forKey:kCommotityListCategoryLastModifyInfo];
    [aCoder encodeObject:_code forKey:kCommotityListCategoryCode];
    [aCoder encodeDouble:_order forKey:kCommotityListCategoryOrder];
    [aCoder encodeDouble:_level forKey:kCommotityListCategoryLevel];
    [aCoder encodeObject:_pictures forKey:kCommotityListCategoryPictures];
    [aCoder encodeObject:_createInfo forKey:kCommotityListCategoryCreateInfo];
    [aCoder encodeObject:_name forKey:kCommotityListCategoryName];
}

- (id)copyWithZone:(NSZone *)zone
{
    CommotityListCategory *copy = [[CommotityListCategory alloc] init];
    
    if (copy) {

        copy.uuid = [self.uuid copyWithZone:zone];
        copy.categoryDescription = [self.categoryDescription copyWithZone:zone];
        copy.state = [self.state copyWithZone:zone];
        copy.version = self.version;
        copy.upper = [self.upper copyWithZone:zone];
        copy.domain = [self.domain copyWithZone:zone];
        copy.path = [self.path copyWithZone:zone];
        copy.lastModifyInfo = [self.lastModifyInfo copyWithZone:zone];
        copy.code = [self.code copyWithZone:zone];
        copy.order = self.order;
        copy.level = self.level;
        copy.pictures = [self.pictures copyWithZone:zone];
        copy.createInfo = [self.createInfo copyWithZone:zone];
        copy.name = [self.name copyWithZone:zone];
    }
    
    return copy;
}


@end
