//
//  CommotityListBrand.m
//
//  Created by Z  on 16/4/11
//  Copyright (c) 2016 __MyCompanyName__. All rights reserved.
//

#import "CommotityListBrand.h"
#import "CommotityListLastModifyInfo.h"
#import "CommotityListCreateInfo.h"


NSString *const kCommotityListBrandUuid = @"uuid";
NSString *const kCommotityListBrandDescription = @"description";
NSString *const kCommotityListBrandState = @"state";
NSString *const kCommotityListBrandVersion = @"version";
NSString *const kCommotityListBrandDomain = @"domain";
NSString *const kCommotityListBrandLastModifyInfo = @"lastModifyInfo";
NSString *const kCommotityListBrandCode = @"code";
NSString *const kCommotityListBrandLocation = @"location";
NSString *const kCommotityListBrandOrder = @"order";
NSString *const kCommotityListBrandLogo = @"logo";
NSString *const kCommotityListBrandCreateInfo = @"createInfo";
NSString *const kCommotityListBrandWebsite = @"website";
NSString *const kCommotityListBrandName = @"name";


@interface CommotityListBrand ()

- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict;

@end

@implementation CommotityListBrand

@synthesize uuid = _uuid;
@synthesize brandDescription = _brandDescription;
@synthesize state = _state;
@synthesize version = _version;
@synthesize domain = _domain;
@synthesize lastModifyInfo = _lastModifyInfo;
@synthesize code = _code;
@synthesize location = _location;
@synthesize order = _order;
@synthesize logo = _logo;
@synthesize createInfo = _createInfo;
@synthesize website = _website;
@synthesize name = _name;


+ (instancetype)modelObjectWithDictionary:(NSDictionary *)dict
{
    return [[self alloc] initWithDictionary:dict];
}

- (instancetype)initWithDictionary:(NSDictionary *)dict
{
    self = [super init];
    
    // This check serves to make sure that a non-NSDictionary object
    // passed into the model class doesn't break the parsing.
    if(self && [dict isKindOfClass:[NSDictionary class]]) {
            self.uuid = [self objectOrNilForKey:kCommotityListBrandUuid fromDictionary:dict];
            self.brandDescription = [self objectOrNilForKey:kCommotityListBrandDescription fromDictionary:dict];
            self.state = [self objectOrNilForKey:kCommotityListBrandState fromDictionary:dict];
            self.version = [[self objectOrNilForKey:kCommotityListBrandVersion fromDictionary:dict] doubleValue];
            self.domain = [self objectOrNilForKey:kCommotityListBrandDomain fromDictionary:dict];
            self.lastModifyInfo = [CommotityListLastModifyInfo modelObjectWithDictionary:[dict objectForKey:kCommotityListBrandLastModifyInfo]];
            self.code = [self objectOrNilForKey:kCommotityListBrandCode fromDictionary:dict];
            self.location = [self objectOrNilForKey:kCommotityListBrandLocation fromDictionary:dict];
            self.order = [[self objectOrNilForKey:kCommotityListBrandOrder fromDictionary:dict] doubleValue];
            self.logo = [self objectOrNilForKey:kCommotityListBrandLogo fromDictionary:dict];
            self.createInfo = [CommotityListCreateInfo modelObjectWithDictionary:[dict objectForKey:kCommotityListBrandCreateInfo]];
            self.website = [self objectOrNilForKey:kCommotityListBrandWebsite fromDictionary:dict];
            self.name = [self objectOrNilForKey:kCommotityListBrandName fromDictionary:dict];

    }
    
    return self;
    
}

- (NSDictionary *)dictionaryRepresentation
{
    NSMutableDictionary *mutableDict = [NSMutableDictionary dictionary];
    [mutableDict setValue:self.uuid forKey:kCommotityListBrandUuid];
    [mutableDict setValue:self.brandDescription forKey:kCommotityListBrandDescription];
    [mutableDict setValue:self.state forKey:kCommotityListBrandState];
    [mutableDict setValue:[NSNumber numberWithDouble:self.version] forKey:kCommotityListBrandVersion];
    [mutableDict setValue:self.domain forKey:kCommotityListBrandDomain];
    [mutableDict setValue:[self.lastModifyInfo dictionaryRepresentation] forKey:kCommotityListBrandLastModifyInfo];
    [mutableDict setValue:self.code forKey:kCommotityListBrandCode];
    [mutableDict setValue:self.location forKey:kCommotityListBrandLocation];
    [mutableDict setValue:[NSNumber numberWithDouble:self.order] forKey:kCommotityListBrandOrder];
    [mutableDict setValue:self.logo forKey:kCommotityListBrandLogo];
    [mutableDict setValue:[self.createInfo dictionaryRepresentation] forKey:kCommotityListBrandCreateInfo];
    [mutableDict setValue:self.website forKey:kCommotityListBrandWebsite];
    [mutableDict setValue:self.name forKey:kCommotityListBrandName];

    return [NSDictionary dictionaryWithDictionary:mutableDict];
}

- (NSString *)description 
{
    return [NSString stringWithFormat:@"%@", [self dictionaryRepresentation]];
}

#pragma mark - Helper Method
- (id)objectOrNilForKey:(id)aKey fromDictionary:(NSDictionary *)dict
{
    id object = [dict objectForKey:aKey];
    return [object isEqual:[NSNull null]] ? nil : object;
}


#pragma mark - NSCoding Methods

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super init];

    self.uuid = [aDecoder decodeObjectForKey:kCommotityListBrandUuid];
    self.brandDescription = [aDecoder decodeObjectForKey:kCommotityListBrandDescription];
    self.state = [aDecoder decodeObjectForKey:kCommotityListBrandState];
    self.version = [aDecoder decodeDoubleForKey:kCommotityListBrandVersion];
    self.domain = [aDecoder decodeObjectForKey:kCommotityListBrandDomain];
    self.lastModifyInfo = [aDecoder decodeObjectForKey:kCommotityListBrandLastModifyInfo];
    self.code = [aDecoder decodeObjectForKey:kCommotityListBrandCode];
    self.location = [aDecoder decodeObjectForKey:kCommotityListBrandLocation];
    self.order = [aDecoder decodeDoubleForKey:kCommotityListBrandOrder];
    self.logo = [aDecoder decodeObjectForKey:kCommotityListBrandLogo];
    self.createInfo = [aDecoder decodeObjectForKey:kCommotityListBrandCreateInfo];
    self.website = [aDecoder decodeObjectForKey:kCommotityListBrandWebsite];
    self.name = [aDecoder decodeObjectForKey:kCommotityListBrandName];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{

    [aCoder encodeObject:_uuid forKey:kCommotityListBrandUuid];
    [aCoder encodeObject:_brandDescription forKey:kCommotityListBrandDescription];
    [aCoder encodeObject:_state forKey:kCommotityListBrandState];
    [aCoder encodeDouble:_version forKey:kCommotityListBrandVersion];
    [aCoder encodeObject:_domain forKey:kCommotityListBrandDomain];
    [aCoder encodeObject:_lastModifyInfo forKey:kCommotityListBrandLastModifyInfo];
    [aCoder encodeObject:_code forKey:kCommotityListBrandCode];
    [aCoder encodeObject:_location forKey:kCommotityListBrandLocation];
    [aCoder encodeDouble:_order forKey:kCommotityListBrandOrder];
    [aCoder encodeObject:_logo forKey:kCommotityListBrandLogo];
    [aCoder encodeObject:_createInfo forKey:kCommotityListBrandCreateInfo];
    [aCoder encodeObject:_website forKey:kCommotityListBrandWebsite];
    [aCoder encodeObject:_name forKey:kCommotityListBrandName];
}

- (id)copyWithZone:(NSZone *)zone
{
    CommotityListBrand *copy = [[CommotityListBrand alloc] init];
    
    if (copy) {

        copy.uuid = [self.uuid copyWithZone:zone];
        copy.brandDescription = [self.brandDescription copyWithZone:zone];
        copy.state = [self.state copyWithZone:zone];
        copy.version = self.version;
        copy.domain = [self.domain copyWithZone:zone];
        copy.lastModifyInfo = [self.lastModifyInfo copyWithZone:zone];
        copy.code = [self.code copyWithZone:zone];
        copy.location = [self.location copyWithZone:zone];
        copy.order = self.order;
        copy.logo = [self.logo copyWithZone:zone];
        copy.createInfo = [self.createInfo copyWithZone:zone];
        copy.website = [self.website copyWithZone:zone];
        copy.name = [self.name copyWithZone:zone];
    }
    
    return copy;
}


@end
