//
//  BaseViewController.m
//  CapitalChamberlain
//
//  Created by 张杰 on 15/11/25.
//  Copyright © 2015年 SunShine. All rights reserved.
//

#import "BaseViewController.h"
#import "HomeViewController.h"
#import "StoreViewController.h"
#import "MassageViewController.h"
#import "MineViewController.h"

@interface BaseViewController ()

@end

@implementation BaseViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
   // [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(presentLoginView) name:@"presentLoginView" object:nil];
    
    HomeViewController *homeVC = [[HomeViewController alloc] init];
    StoreViewController *storeVC = [[StoreViewController alloc] init];
    MassageViewController *masageVC = [[MassageViewController alloc] init];
    MineViewController *mineVC = [[MineViewController alloc] init];
    

    
    [self addChildVC:homeVC title:@"店铺" imageName:@"home_tabbar" selectImgName:@"home_selected_tabbar"];
    [self addChildVC:storeVC title:@"商城" imageName:@"store_tabbar" selectImgName:@"store_selected_tabbar"];

    [self addChildVC:masageVC title:@"消息" imageName:@"message_tabbar" selectImgName:@"message_selected_tabbar"];
    [self addChildVC:mineVC title:@"我的" imageName:@"mine_tabbar" selectImgName:@"mine_selected_tabbar"];
    
    UIView *bgView = [[UIView alloc] initWithFrame:self.tabBar.bounds];
    bgView.backgroundColor = [UIColor colorWithWhite:0.941 alpha:1.000];
    [self.tabBar insertSubview:bgView atIndex:0];
    self.tabBar.opaque = YES;
   
    // Do any additional setup after loading the view.
}


- (void)addChildVC:(UIViewController *)childVC title:(NSString *)title imageName:(NSString *)imageName selectImgName:(NSString *)selectImgName {
    
   
    
    //设置导航控制器
    IBTUINavigationController *childNC = [[IBTUINavigationController alloc] initWithRootViewController:childVC];
    
    //导航控制器标题
    childVC.navigationItem.title = title;
    
    childNC.navigationBar.translucent = NO;
    //导航栏颜色
//    childNC.navigationBar.barTintColor = kRed;


    //tabBar字体颜色
    self.tabBar.tintColor = kCustomGreenColor;
    
    //tabBar上面的item的标题
    childNC.tabBarItem.title = title;
    
    //item图标
    [childNC.tabBarItem setImage:[[UIImage imageNamed:imageName] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal]];
    
    [childNC.tabBarItem setSelectedImage:[[UIImage imageNamed:selectImgName] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal]];
    
    //[[UITabBarItem appearance] setTitleTextAttributes:@{NSFontAttributeName:[UIFont fontWithName:@"Helvetica" size:17.0]} forState:UIControlStateNormal];
    
    [self addChildViewController:childNC];
    
    
    
    //设置导航栏字体颜色
    NSDictionary *attributes = [NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName, nil];
    [childNC.navigationBar setTitleTextAttributes:attributes];
    
}


//- (void)presentLoginView
//{
//    LoginViewController *loginVC = [[LoginViewController alloc] init];
//    UINavigationController *navc = [[UINavigationController alloc] initWithRootViewController:loginVC];
//    loginVC.loginBk = ^(){
//        
//    };
//    loginVC.hidesBottomBarWhenPushed = YES;
//    [self presentViewController:navc animated:YES completion:nil];
//}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
