
//
//  GTOCommonTools.m
//  total
//
//  Created by freecui on 15/10/15.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOCommonTools.h"

@implementation GTOCommonTools

#pragma mark - Class Method
+ (instancetype)sharedManager {
    static GTOCommonTools *_tool = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _tool = [[[self class] alloc] init];
    });
    
    return _tool;
}
//null 转@“”
+ (NSString *)nullChangedWithId: (id)data {
    if ([data isKindOfClass:[NSNull class]] || !data) {
        return @"";
    } else {
        return data;
    }
}
+ (NSString *)stringWithId:(id)data {
    if (!data || [data isEqual:[NSNull null]]) {
        return @"";
    }
    return [NSString stringWithFormat:@"%@",data];
}
+ (NSDate *)dateWithString:(NSString *)string {
    NSDateFormatter* dateFormat = [[NSDateFormatter alloc] init];
    [dateFormat setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
    NSDate *date = [dateFormat dateFromString:string];
    
    return date;
}

+ (NSString *)stringLetterWithNumber: (NSInteger)number {//数字对应字母
    NSString *letter;
    switch (number) {
        case 0:
            letter = @"A";
            break;
        case 1:
            letter = @"B";
            break;
        case 2:
            letter = @"C";
            break;
        case 3:
            letter = @"D";
            break;
        default:
            break;
    }
    
    return letter;
}
+ (NSString *)dateSubstringDeleteZeroWithDateString:(NSString *)string {
    
    if ([string containsString:@"+"]) {
        NSUInteger index = [string rangeOfString:@"+"].location;
        return [string substringToIndex:index];
    }
    return string;
}

@end