//
//  AppHeader.h
//  ALand
//
//  Created by Z on 16/3/17.
//  Copyright © 2016年 Z. All rights reserved.
//

#ifndef AppHeader_h
#define AppHeader_h
// COLOR

#define kMainTextColor [UIColor colorWithRed:0.486 green:0.765 blue:0.145 alpha:1.000];
#define kCustomGrayColor [UIColor colorWithWhite:0.533 alpha:1.000];
#define kCustomGreenColor [UIColor colorWithRed:0.486 green:0.765 blue:0.145 alpha:1.000]
#define kRandomColor [UIColor colorWithRed:arc4random()%256/255.0 green:arc4random()%256/255.0 blue:arc4random()%256/255.0 alpha:1.000]
#define kBacroundColor                   [UIColor colorWithWhite:0.949 alpha:1.000]
#define kTextColorBlack                   [UIColor colorWithWhite:0.067 alpha:1.000]
#define kTextColorDarkGray                   [UIColor colorWithWhite:0.200 alpha:1.000]
#define kTextColorGray                   [UIColor colorWithWhite:0.400 alpha:1.000]
#define kTextColorLiteGray                  [UIColor colorWithWhite:0.600 alpha:1.000]

#define kCutLineColorLiteGray [UIColor colorWithWhite:0.867 alpha:1.000]
#define kCutLineColorGray [UIColor colorWithWhite:0.820 alpha:1.000]
#define kCutLineColorDarkGray [UIColor colorWithWhite:0.757 alpha:1.000]
#define kPriceColor [UIColor colorWithRed:1.000 green:0.392 blue:0.392 alpha:1.000];


#pragma mark =========== 通用宏定义 start ===========

#define kBounds [UIScreen mainScreen].bounds
#define kWidth [UIScreen mainScreen].bounds.size.width
#define kHeight [UIScreen mainScreen].bounds.size.height
#define kAutoValue(value) (float)value / 375 * kWidth
#define WS(weakSelf)  __weak __typeof(&*self)weakSelf = self;
#define HexColor(colorStr)      [UIColor colorWithHexString:colorStr]
#define RGBA(R,G,B,A)           [UIColor colorWithRed:R/255.0f green:G/255.0f blue:B/255.0f alpha:A]
#define ScreenSize              ([[UIScreen mainScreen] bounds].size)
#define IOS7                    ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0)
#define FontSize(num)           [UIFont systemFontOfSize:num]
#define AppWindow               [[UIApplication sharedApplication].delegate window]
#define GXF_NSUSERFEFTAULTS     [NSUserDefaults standardUserDefaults]
#define IsNotNullObject(Object)          ![(Object) isKindOfClass:[NSNull class]]
#define IsNumObject(Object)   (IsNotNullObject(Object) && [(Object) isKindOfClass:[NSNumber class]])
#define IsStrObject(Object)   (IsNotNullObject(Object) && [(Object) isKindOfClass:[NSString class]] && [Object length] > 0)
#define IsIntObject(Object)   (IsNotNullObject(Object) && [Object integerValue] >= 0)
#define IsFloatObject(Object)    (IsNotNullObject(Object) && [Object floatValue] >= 0)
#define IsUintObject(Object)     (IsNotNullObject(Object) && [Object intValue] > 0)
#define IsArrayObject(Object)            [(Object) isKindOfClass:[NSArray class]]
#define IsDictObject(Object)             [(Object) isKindOfClass:[NSDictionary class]]
#define IsErrorObject(Object)            ![(Object) isKindOfClass:[NSError class]]
#define kSysWhite         [UIColor whiteColor]

#pragma mark =========== end ===========


#define ICR_TINTCOLOR                   [UIColor colorWithR:63 g:134 b:244 a:1]//天蓝色
#define ICR_VIEW_BG_COLOR               [UIColor whiteColor]

#define ICR_GRAY_BTN_COLOR              [UIColor lightGrayColor]
#define ICR_ORANGE_BTN_COLOR            [UIColor colorWithR:250 g:155 b:52 a:1]
#define ICR_DISABLE_BTN_COLOR           [UIColor colorWithW:202 a:1]
#define ICR_NAVIBAR_ITEM_COLOR          [UIColor whiteColor]
#define ICR_NAVIBAR_ITEM_DISABLE_COLOR  [UIColor colorWithW:1 a:.5f]
#define ICR_NAVIBAR_TITLE_COLOR         [UIColor whiteColor]
#define ICR_TABBAR_TINT_COLOR           [UIColor colorWithR:36 g:38 b:53 a:1] //黑色
#define ICR_IMAGE_BG_COLOR              [UIColor colorWithW:242 a:1]







#endif /* AppHeader_h */
