//
//  IBTUIView.m
//  Cruiser
//
//  Created by Xummer on 3/30/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTUIView.h"

@implementation IBTUIView

- (instancetype)initWithFrame:(CGRect)frame
              processBarFloat: (CGFloat)processData
              processBarColor: (UIColor *)processColor
           viewBorderBarColor: (UIColor *)borderColor{
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    self.backgroundColor = HexColor(@"#F8F8F8");//GTO_BACKGROUND_GRAY_SHALLOW_COLOR;
    self.layer.cornerRadius = 3;
    self.layer.masksToBounds = YES;
    CGFloat borderWidth = 1.0f;
    UIView *processV = [[UIView alloc]initWithFrame:CGRectMake(borderWidth, borderWidth,(frame.size.width - 2 * borderWidth ) * processData , frame.size.height - 2 * borderWidth)];//
    UIImageView *imgV = [[UIImageView alloc]initWithFrame:processV.bounds];
    UIImage *image = [UIImage imageNamed:@"bar_bg"];
    image = [image resizableImageWithCapInsets:UIEdgeInsetsZero resizingMode:UIImageResizingModeTile];
    imgV.image = image;
    [processV addSubview:imgV];
    //    processV.backgroundColor = processColor;
    processV.layer.cornerRadius = 3;
    processV.layer.masksToBounds = YES;
    [self addSubview:processV];
    
    self.layer.borderWidth = borderWidth;
    self.layer.borderColor = [borderColor CGColor];
    
    return self;
}

//- (instancetype)initBarViewWithprocessBarFloat: (CGFloat)processData
//                               processBarColor: (UIColor *)processColor
//                            viewBorderBarColor: (UIColor *)borderColor
//{
//    self = [super init];
//    if (!self) {
//        return nil;
//    }
//
//    CGFloat borderWidth = 1.0f;
//    UIView *processV = [[UIView alloc]initWithFrame:CGRectMake(borderWidth, borderWidth, (self.size.width - 2 * borderWidth ) * processData, self.size.height - 2 * borderWidth)];
//    processV.backgroundColor = processColor;
//    [self addSubview:processV];
//
//    self.layer.borderWidth = borderWidth;
//    self.layer.borderColor = [borderColor CGColor];
//
//    return self;
//
//}
/*
 // Only override drawRect: if you perform custom drawing.
 // An empty implementation adversely affects performance during animation.
 - (void)drawRect:(CGRect)rect {
 // Drawing code
 }
 */

@end
