//
//  IBTUIButton.m
//  Cruiser
//
//  Created by Xummer on 3/30/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTUIButton.h"

@implementation IBTUIButton

+ (id)RoundCornerBtnWithTitle:(NSString *)title bgColor:(UIColor *)bgColor {
    IBTUIButton *btn = [IBTUIButton buttonWithType:UIButtonTypeCustom];
    [btn setTitle:title forState:UIControlStateNormal];
    [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    btn.titleLabel.font = [UIFont systemFontOfSize:12.0];
    [btn setBackgroundImage:[UIImage imageWithColor:bgColor ? : ICR_TINTCOLOR ]
                   forState:UIControlStateNormal];
    [btn setBackgroundImage:[UIImage imageWithColor:ICR_DISABLE_BTN_COLOR]
                   forState:UIControlStateDisabled];
    btn.layer.cornerRadius = 4;
    btn.layer.masksToBounds = YES;
    return btn;
}
+ (IBTUIButton *)buttonWithTitle: (NSString *)title
                       textColor: (UIColor *)textColor
                        textFont: (UIFont *)font
                       backColor: (UIColor *)bgColor{
    IBTUIButton *btn = [[IBTUIButton alloc]init];
    [btn setTitle:title forState:UIControlStateNormal];
    [btn setTitleColor:textColor forState:UIControlStateNormal];
    [btn setBackgroundImage:[UIImage imageWithColor:bgColor ? : ICR_TINTCOLOR]
                   forState:UIControlStateNormal];
    btn.titleLabel.font = font;
    return btn;
}
@end
