//
//  CoverShadowView.m
//  ALand
//
//  Created by Z on 16/3/24.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "CoverShadowView.h"

@implementation CoverShadowView


- (instancetype)initWithSpaceToTop:(CGFloat)spaceToTop;
{
    self = [super init];
    if (self) {
        self.backgroundColor = [UIColor colorWithWhite:0.000 alpha:0.172];
        self.alpha = 0;
        self.frame = CGRectMake(0, spaceToTop, ScreenSize.width, ScreenSize.height - spaceToTop);
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(doTap)];
        [self addGestureRecognizer:tap];
    }
    return self;
}

- (instancetype)initOnTopWithHeight:(CGFloat)height {
    self = [super init];
    if (self) {
        self.backgroundColor = [UIColor colorWithWhite:0.000 alpha:0.172];
        self.alpha = 0;
        self.frame = CGRectMake(0, 0, ScreenSize.width, height);
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(doTap)];
        [self addGestureRecognizer:tap];
    }
    return self;
}

- (void)doTap {
    [self hide];
    self.tapAction();
}

- (void)show {
    WS(weakSelf)
    [UIView animateWithDuration:0.2 animations:^{
        weakSelf.alpha = 1;
    }];

    
}

- (void)hide {
    WS(weakSelf)
    [UIView animateWithDuration:0.2 animations:^{
        weakSelf.alpha = 0;
    }];
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
