//
//  MyTools.m
//  CapitalChamberlain
//
//  Created by 张杰 on 15/12/10.
//  Copyright © 2015年 SunShine. All rights reserved.
//

#import "MyTools.h"
#import "UIView+SDAutoLayout.h"
@implementation MyTools

//动画
+ (void)animateToBottomDuration:(NSTimeInterval)duration view:(UIView *)view
{
    __weak UIView *aView = view;
    CGFloat y = view.top;
    CGFloat height = view.height;
    [UIView animateWithDuration:duration animations:^{
        aView.top = y + height;
    }];
}

+ (void)animateFromBottomDuration:(NSTimeInterval)duration view:(UIView *)view viewHeight:(CGFloat)height
{
    __weak UIView *aView = view;
    CGFloat y = view.top;
    CGFloat height1 = view.height;
    [UIView animateWithDuration:duration animations:^{
        aView.top = y - height1;
    }];
}

+ (void)appearAndDisappearAnimateDuration:(NSTimeInterval)duration view:(UIView *)view
{
    __weak UIView *aView = view;
    [UIView animateWithDuration:duration animations:^{
        aView.alpha = 1;
    } completion:^(BOOL finished) {
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.2 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            [UIView animateWithDuration:duration animations:^{
                aView.alpha = 0;
            }];
        });
    }];
}

//日期转换成string
+ (NSString *)stringFromDate:(NSDate *)date format:(NSString *)format{
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    //zzz表示时区，zzz可以删除，这样返回的日期字符将不包含时区信息。
    
    [dateFormatter setDateFormat:format];
    
    NSString *destDateString = [dateFormatter stringFromDate:date];
    return destDateString;
    
}

//判断手机号是否正确
+ (NSString *)valiMobile:(NSString *)mobile{
    if (mobile.length < 11)
    {
        return @"手机号长度只能是11位";
    }else{
        /**
         * 移动号段正则表达式
         */
        NSString *CM_NUM = @"^((13[4-9])|(147)|(15[0-2,7-9])|(178)|(18[2-4,7-8]))\\d{8}|(1705)\\d{7}$";
        /**
         * 联通号段正则表达式
         */
        NSString *CU_NUM = @"^((13[0-2])|(145)|(15[5-6])|(176)|(18[5,6]))\\d{8}|(1709)\\d{7}$";
        /**
         * 电信号段正则表达式
         */
        NSString *CT_NUM = @"^((133)|(153)|(177)|(18[0,1,9]))\\d{8}$";
        NSPredicate *pred1 = [NSPredicate predicateWithFormat:@"SELF MATCHES %@", CM_NUM];
        BOOL isMatch1 = [pred1 evaluateWithObject:mobile];
        NSPredicate *pred2 = [NSPredicate predicateWithFormat:@"SELF MATCHES %@", CU_NUM];
        BOOL isMatch2 = [pred2 evaluateWithObject:mobile];
        NSPredicate *pred3 = [NSPredicate predicateWithFormat:@"SELF MATCHES %@", CT_NUM];
        BOOL isMatch3 = [pred3 evaluateWithObject:mobile];
        
        if (isMatch1 || isMatch2 || isMatch3) {
            return nil;
        }else{
            return @"请输入正确的电话号码";
        }
    }
    return nil;
}

+ (UILabel *)labelWithFontSize:(CGFloat)font textColor:(UIColor *)color top:(CGFloat)top bottom:(CGFloat)bottom left:(CGFloat)left right:(CGFloat)right centerX:(CGFloat)centerX centerY:(CGFloat)centerY isSizeToFit:(BOOL)isSizeToFit  width:(CGFloat)width height:(CGFloat)height cotent:(NSString *)content
{
    UILabel *label = [UILabel new];
    label.textColor = color;
    label.text = content;
    label.font = [UIFont systemFontOfSize:font];
    label.numberOfLines = 0;
    
    
    if (width != -1) {
        label.width = width;
    }
    
    if (height != -1) {
        label.height = height;
    }
    
    if (isSizeToFit) {
        
        [label sizeToFit];
    }
    
    if (left != -1) {
        label.left = left;
    }
    
    if (right != -1) {
        label.right = right;
    }
    if (bottom != -1) {
        label.bottom = bottom;
    }
    if (top != -1) {
        label.top = top;
    }
    
    if (centerX != -1) {
        label.centerX = centerX;
    }
    
    if (centerY != -1) {
        label.centerY = centerY;
    }
    
    return label;
}

+ (UIButton *)buttonWithType:(UIButtonType)buttonType FontSize:(CGFloat)font textColor:(UIColor *)color top:(CGFloat)top bottom:(CGFloat)bottom left:(CGFloat)left right:(CGFloat)right centerX:(CGFloat)centerX centerY:(CGFloat)centerY isSizeToFit:(BOOL)isSizeToFit  width:(CGFloat)width height:(CGFloat)height cotent:(NSString *)content action:(SEL)action target:(id)target
{
    UIButton *button = [UIButton buttonWithType:buttonType];
    [button setTitle:content forState:UIControlStateNormal];
    [button setTitleColor:color forState:UIControlStateNormal];
    if (target != nil) {
        
        [button addTarget:target action:action forControlEvents:UIControlEventTouchUpInside];
    }
    
    if (font != -1) {
        
        button.titleLabel.font = [UIFont systemFontOfSize:font];
    }
    
    if (width != -1) {
        button.width = width;
    }
    
    if (height != -1) {
        button.height = height;
    }
    
    if (isSizeToFit) {
        
        [button sizeToFit];
    }
    
    if (left != -1) {
        button.left = left;
    }
    
    if (right != -1) {
        button.right = right;
    }
    if (bottom != -1) {
        button.bottom = bottom;
    }
    if (top != -1) {
        button.top = top;
    }
    
    if (centerX != -1) {
        button.centerX = centerX;
    }
    
    if (centerY != -1) {
        button.centerY = centerY;
    }
    return button;
}

+ (UITableView *)tableViewWithStyle:(UITableViewStyle)style Top:(CGFloat)top bottom:(CGFloat)bottom left:(CGFloat)left right:(CGFloat)right centerX:(CGFloat)centerX centerY:(CGFloat)centerY width:(CGFloat)width height:(CGFloat)height delegateAndDatasource:(id)target rigistClass:(Class)cellClass CellReuseIdentifier:(NSString *)identifier separatorStyle:(BOOL)separator
{
    UITableView *tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 0, 0, 0) style:style];
    tableView.delegate = target;
    tableView.dataSource = target;
    tableView.separatorStyle = separator;
    [tableView registerClass:cellClass forCellReuseIdentifier:identifier];
    
    if (width != -1) {
        tableView.width = width;
    }
    
    if (height != -1) {
        tableView.height = height;
    }
    
    
    if (left != -1) {
        tableView.left = left;
    }
    
    if (right != -1) {
        tableView.right = right;
    }
    if (bottom != -1) {
        tableView.bottom = bottom;
    }
    if (top != -1) {
        tableView.top = top;
    }
    
    if (centerX != -1) {
        tableView.centerX = centerX;
    }
    
    if (centerY != -1) {
        tableView.centerY = centerY;
    }
    
    return tableView;
}

+ (UIImageView *)imageViewBackGroundColor:(UIColor *)color top:(CGFloat)top left:(CGFloat)left bottom:(CGFloat)bottom right:(CGFloat)right centerX:(CGFloat)centerX centerY:(CGFloat)centerY  width:(CGFloat)width height:(CGFloat)height cornerRadius:(CGFloat)cornerRadius
{
    UIImageView *imagView = [UIImageView new];
    imagView.backgroundColor = color;
    
    [self setView:imagView withTop:top left:left bottom:bottom right:right centerX:centerX centerY:centerY width:width height:height cornerRadius:cornerRadius];
    
    
    return imagView;
}


//设置view的位置大小等属性
+ (void)setView:(UIView *)tableView withTop:(CGFloat)top left:(CGFloat)left bottom:(CGFloat)bottom right:(CGFloat)right centerX:(CGFloat)centerX centerY:(CGFloat)centerY  width:(CGFloat)width height:(CGFloat)height cornerRadius:(CGFloat)cornerRadius
{
    if (width != -1) {
        tableView.width = width;
    }
    
    if (height != -1) {
        tableView.height = height;
    }
    
    
    if (left != -1) {
        tableView.left = left;
    }
    
    if (right != -1) {
        tableView.right = right;
    }
    if (bottom != -1) {
        tableView.bottom = bottom;
    }
    if (top != -1) {
        tableView.top = top;
    }
    
    if (centerX != -1) {
        tableView.centerX = centerX;
    }
    
    if (centerY != -1) {
        tableView.centerY = centerY;
    }
    
    if (cornerRadius != 0) {
        tableView.layer.masksToBounds = YES;
        tableView.layer.cornerRadius = cornerRadius;
    }

}


+ (UIImage*)imageFromView:(UIView*)view{
    
    UIGraphicsBeginImageContextWithOptions(view.bounds.size, YES, view.layer.contentsScale);
    
    [view.layer renderInContext:UIGraphicsGetCurrentContext()];
    
    UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
    
    UIGraphicsEndImageContext();
    
    return image;
    
}

+(void)showAlertWithStringAndTitle:(NSString *)msg title:(NSString*)title {
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:title message:msg delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil];
    [alert show];
}

+ (NSString *)LongToDate:(NSNumber *)pDate WithFormat:(NSString *)format{
    long long theDate = [pDate longLongValue];
    NSDate *date=[[NSDate alloc] initWithTimeIntervalSince1970:theDate/1000];
    NSDateFormatter* dateFormat = [[NSDateFormatter alloc] init];
    [dateFormat setDateFormat:format];
    NSString *strdate = [dateFormat stringFromDate:date];
    return strdate;
}

+ (void)userDefaultSetObject:(id)object forKey:(NSString *)key
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    [defaults setObject:object forKey:key];
}

+ (id)userDefaultObjectforKey:(NSString *)key
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    return [defaults objectForKey:key];
}
@end
