//
//  JavenMultipleViewWithHeader.m
//  multipleView
//
//  Created by Z on 16/3/15.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "JavenMultipleViewWithHeader.h"



@interface JavenMultipleViewWithHeader ()

@property (nonatomic, strong) UIScrollView *viewScrollView;
@property (nonatomic, strong) NSArray *viewArr;
@property (nonatomic, strong) NSArray *titleArr;
@property (nonatomic, strong) NSMutableArray *buttonArr;

@property (nonatomic, strong) UIColor *selectTextColor;
@property (nonatomic, strong) UIColor *selectBackgroundColor;
@property (nonatomic, strong) UIColor *textColor;
@property (nonatomic, strong) UIColor *abackgroundColor;
@property (nonatomic, strong) UIColor *forceColor;
@property (nonatomic, strong) UIColor *normalColor;
@property (nonatomic, assign) CGFloat titleButtonWith;
@property (nonatomic, assign) CGFloat titleScrollViewHeight;

@property (nonatomic, strong) UIView *bottomFlowView;


@end


@implementation JavenMultipleViewWithHeader


- (instancetype)initWithFrame:(CGRect)frame views:(NSArray *)views titles:(NSArray *)titles target:(id)target selectTextColor:(UIColor *)selectTextColor selectBackgroundColor:(UIColor *)selectBackgroundColor textColor:(UIColor *)textColor backgroundColor:(UIColor *)abackgroundColor titleHeight:(CGFloat)height titleBtnWidth:(CGFloat)width{
    self = [super initWithFrame:frame];
    if (self) {
        _selectTextColor = selectTextColor;
        _selectBackgroundColor = selectBackgroundColor;
        _textColor = textColor;
        _abackgroundColor = abackgroundColor;
        _titleButtonWith = width;
        _titleScrollViewHeight = height;
        
        self.backgroundColor = kCutLineColorLiteGray;
        _viewArr = views;
        _titleArr = titles;
        //set titleButton
        UIScrollView *titleScrollView = [[UIScrollView alloc] initWithFrame:CGRectMake(0, 0, frame.size.width, _titleScrollViewHeight)];
        titleScrollView.backgroundColor = kCutLineColorLiteGray;
        titleScrollView.tag = 111000;
        titleScrollView.delegate = self;
        titleScrollView.contentSize = CGSizeMake(_titleButtonWith * titles.count, 0);
        titleScrollView.showsHorizontalScrollIndicator = NO;//水平进度条
        [self addSubview:titleScrollView];
        
        UIView *viewLineTop = [[UIView alloc] initWithFrame:CGRectMake(0, 0, titleScrollView.width, 1)];
        viewLineTop.backgroundColor = kCutLineColorLiteGray;
        [self addSubview:viewLineTop];
        
        UIView *viewLineBottom = [UIView new];
        viewLineBottom.backgroundColor = kCutLineColorLiteGray;
        [self addSubview:viewLineBottom];
        viewLineBottom.sd_layout.leftEqualToView(self).rightEqualToView(self).bottomEqualToView(titleScrollView).heightIs(1);

        

        
        
        _buttonArr = [NSMutableArray array];
        for (int i = 0; i < titles.count; i++) {
            UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
            [button setTitle:titles[i] forState:UIControlStateNormal];
            button.titleLabel.font = [UIFont systemFontOfSize:16];
            
            [button setTitleColor:_textColor forState:UIControlStateNormal];
            button.backgroundColor = _abackgroundColor;
            
            if (i == 0) {
                [button setTitleColor:_selectTextColor forState:UIControlStateNormal];
                [button setBackgroundColor:_selectBackgroundColor];
            }
            
            button.frame = CGRectMake(_titleButtonWith * i, 0, _titleButtonWith, _titleScrollViewHeight);
            
            [_buttonArr addObject:button];
            button.tag = 11100 + i;
            [button addTarget:self action:@selector(changeToSelectedView:) forControlEvents:UIControlEventTouchUpInside];
            [titleScrollView addSubview:button];
        }
        
        
        UIScrollView *viewScrollView = [[UIScrollView alloc] initWithFrame:CGRectMake(0, _titleScrollViewHeight, frame.size.width, frame.size.height - _titleScrollViewHeight)];
        NSLog(@"height = %f, y = %f", viewScrollView.frame.size.height, viewScrollView.frame.origin.y
              );
        _viewScrollView = viewScrollView;
        viewScrollView.showsVerticalScrollIndicator = NO;
        viewScrollView.delegate = self;
        viewScrollView.pagingEnabled = YES;
        viewScrollView.tag = 111001;
        viewScrollView.contentSize = CGSizeMake(frame.size.width * titles.count, 0);
        [self addSubview:viewScrollView];
        for (int i = 0; i < views.count; i++) {
            UIViewController *viewController = views[i];
            [[self viewController] addChildViewController:viewController];
            viewController.view.frame = CGRectMake(frame.size.width * i, 0, frame.size.width, frame.size.height - _titleScrollViewHeight);
            [target addChildViewController:viewController];
            [viewScrollView addSubview:viewController.view];
        }
        
        _bottomFlowView = [[UIView alloc] initWithFrame:CGRectMake(0, _titleScrollViewHeight - 3, _titleButtonWith, 3)];
        _bottomFlowView.backgroundColor = _selectTextColor;
        [titleScrollView addSubview:_bottomFlowView];
        
        
    }
    return self;
}

- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView {
    if (scrollView.tag == 111001) {
        NSLog(@"%f",scrollView.contentOffset.y);
        
        for (UIButton *btn in _buttonArr) {
            if (btn.tag == scrollView.contentOffset.x / self.frame.size.width + 11100) {
                [btn setTitleColor:_selectTextColor forState:UIControlStateNormal];
                btn.backgroundColor = _selectBackgroundColor;
                WS(weakSelf)
                [UIView animateWithDuration:0.3 animations:^{
                    weakSelf.bottomFlowView.centerX = btn.centerX;
                }];

            }else{
                 [btn setTitleColor:_textColor forState:UIControlStateNormal];
                btn.backgroundColor = _abackgroundColor;
            }
        }
    }
}

- (void)changeToSelectedView:(UIButton *)btn {
    for (UIButton *button in _buttonArr) {
        button.backgroundColor = _abackgroundColor;
        [button setTitleColor:_textColor forState:UIControlStateNormal];

    }
    
    WS(weakSelf)
    [UIView animateWithDuration:0.3 animations:^{
        weakSelf.bottomFlowView.centerX = btn.centerX;
    }];
    
    [btn setBackgroundColor:_selectBackgroundColor];
    [btn setTitleColor:_selectTextColor forState:UIControlStateNormal];
    
    
    NSInteger currentIndex = btn.tag - 11100;
    //_viewScrollView.contentOffset = CGPointMake(currentIndex * self.frame.size.width, 0);
    [_viewScrollView setContentOffset:CGPointMake(currentIndex * self.frame.size.width, 0) animated:YES];
}



/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
