//
//  UIImage+WaterMark.m
//  patrol
//
//  Created by Z on 16/3/14.
//  Copyright © 2016年 free. All rights reserved.
//

#import "UIImage+WaterMark.h"

@implementation UIImage (WaterMark)
- (UIImage *)watermarkImage:(NSString *)text{
    
    
    //1.获取上下文
    
    UIGraphicsBeginImageContext(self.size);
    
    
    //2.绘制图片
    
    [self drawInRect:CGRectMake(0, 0, self.size.width, self.size.height)];
    
    
    
    //3.绘制水印文字
    
    CGRect rect = CGRectMake(0, self.size.height - 200, self.size.width, 200);
    
        
    NSMutableParagraphStyle *style = [[NSMutableParagraphStyle defaultParagraphStyle] mutableCopy];
    
    style.alignment = NSTextAlignmentCenter;
    
    //文字的属性
    CGContextRef ctx = UIGraphicsGetCurrentContext();  // 获取绘图的CGContextRef
    // 使用默认的阴影颜色，阴影向左上角投影，模糊度为5
    CGContextSetShadow(ctx, CGSizeMake(8, 6), 5);
//    CGContextSetRGBFillColor (ctx, 1, 0, 1, 1);  // 设置填充颜色
//    CGContextSetRGBStrokeColor (ctx, 0, 0, 1, 1);  // 设置线条颜色
    CGContextSetTextDrawingMode (ctx, kCGTextFill);  // 设置使用填充模式绘制文字
    
    NSDictionary *dic = @{
                          
                          NSFontAttributeName:[UIFont systemFontOfSize:100],
                          
                          NSParagraphStyleAttributeName:style,
                          
                          NSForegroundColorAttributeName:[UIColor yellowColor]
                          
                          };
    //CGContextSetTextDrawingMode (ctx, kCGTextStroke);
    
    //将文字绘制上去
    
    [text drawInRect:rect withAttributes:dic];
    
    
    
    //4.获取绘制到得图片
    
    UIImage *watermarkImage = UIGraphicsGetImageFromCurrentImageContext();
    
    
    
    //5.结束图片的绘制
    
    UIGraphicsEndImageContext();
    
    
    
    return watermarkImage;
    
}
@end
