//
//  ToLoginViewController.m
//  ALand
//
//  Created by Z on 16/3/17.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "ToLoginViewController.h"
#import "ResetPasswordViewController.h"
#import "BaseViewController.h"
@interface ToLoginViewController ()
@property (weak, nonatomic) IBOutlet UITextField *phoneNumberTextFiled;
@property (weak, nonatomic) IBOutlet UITextField *passwordTextFiled;

@end

@implementation ToLoginViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"登 录";
        // Do any additional setup after loading the view from its nib.
}


- (IBAction)toLoginAction:(UIButton *)sender {
    
    NSDictionary *paramers = @{@"domain":kDomain,
                               @"loginName":self.phoneNumberTextFiled.text ,
                               @"password":[self.passwordTextFiled.text MD5String],
                               @"rememberMe":@"true"};
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    [[HTTPCilent shareCilent] POST:@"app/resellerLogin" parameters:paramers success:^(NSURLSessionDataTask *task, id responseObject) {
        UserInfo *info = [UserInfo shareInstance];
        info = [UserInfo mj_objectWithKeyValues:responseObject[@"reseller"]];
        
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    } failure:^(NSURLSessionDataTask *task, NSError *error) {
        
    }];
    
    
    BaseViewController *baseVC = [[BaseViewController alloc] init];
    baseVC.modalTransitionStyle = UIModalTransitionStyleCrossDissolve;
    [self presentViewController:baseVC animated:YES completion:nil];
}


- (IBAction)forgetPasswordAction:(UIButton *)sender {
    ResetPasswordViewController *resetVC = [[ResetPasswordViewController alloc] initWithNibName:@"ResetPasswordViewController" bundle:[NSBundle mainBundle]];
    [self.navigationController pushViewController:resetVC animated:YES];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:NO];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
