//
//  OrderDetailViewController.m
//  ALand
//
//  Created by Z on 16/3/30.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "OrderDetailViewController.h"
#import "NSString+Category.h"
#import "OrderDetailTableViewCell.h"
#import "UITableView+Category.h"
#import "SeeLogistics.h"
#define kCellId @"OrderDetailTableViewCell.h"
@interface OrderDetailViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;
@end

@implementation OrderDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = kCustomGreenColor;
    self.navigationItem.title = @"订单详情";
    
    //tableView
    self.tableView = [UITableView plainTableViewWithTarget:self cellNibName:@"OrderDetailTableViewCell" cellId:kCellId];
    self.tableView.frame = CGRectMake(0, 0, kWidth, kHeight);
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    self.tableView.backgroundColor = kBacroundColor;
    
    [self.view addSubview:self.tableView];//topView
    OrderDetailTopView *topView = [OrderDetailTopView viewWithNibName:@"OrderDetailTopView"];
    topView.width = kWidth;
    topView.labelAddress.text = [NSString randomTestText];
    topView.labelRemark.text = [NSString randomTestText];
    topView.frame = CGRectMake(0, -topView.viewHeight, kWidth, topView.viewHeight);
    
    self.tableView.contentInset = UIEdgeInsetsMake(topView.viewHeight, 0, 64 + 65, 0);
    [self.tableView addSubview:topView];
    
    //改变tag
    topView.orderType = self.orderType;
    [topView updateTag];//根据
    
    
    //底部查看物流按钮
    if (self.orderType == ORDERTOPTYPE_TRANSPORTED) {
        SeeLogistics *viewBottom = [SeeLogistics viewWithNibName:@"SeeLogistics"];
        viewBottom.frame = CGRectMake(0, kHeight - 64 - 65, kWidth,  64 + 65);
        [self.view addSubview:viewBottom];
    }
    
    // Do any additional setup after loading the view.
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 316;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 3;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    OrderDetailTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:kCellId forIndexPath:indexPath];
    return cell;
}
- (void)setUpTableView {
    
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
