//
//  NoPaymentTableViewController.m
//  ALand
//
//  Created by Z on 16/3/30.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "NoPaymentTableViewController.h"
#import "OrderTableViewCell.h"
#import "OrderDetailViewController.h"

#define kCellId @"OrderTableViewCell.h"
@interface NoPaymentTableViewController ()
@property (nonatomic, strong) NSArray *array;
@end

@implementation NoPaymentTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.array = @[@2,@3,@5,@10];
    [self.tableView registerNib:[UINib nibWithNibName:@"OrderTableViewCell" bundle:[NSBundle mainBundle]] forCellReuseIdentifier:kCellId];
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    self.tableView.contentInset = UIEdgeInsetsMake(0, 0, 64, 0);

}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 115 + 120 * [self.array[indexPath.row] integerValue];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
#warning Incomplete implementation, return the number of sections
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
#warning Incomplete implementation, return the number of rows
    return self.array.count;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    OrderTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:kCellId forIndexPath:indexPath];
    
    // Configure the cell...
   
    [cell cellWithViewNumber: [self.array[indexPath.row] integerValue]];
    [cell setState:_orderTag];
    return cell;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    OrderDetailViewController *orderDetailVC = [[OrderDetailViewController alloc] init];
    if ([self.orderTag isEqualToString:@"代支付"]) {
        orderDetailVC.orderType = ORDERTOPTYPE_NOPAYMENT;
    }else if([self.orderTag isEqualToString:@"待发货"]){
        orderDetailVC.orderType = ORDERTOPTYPE_WAITFORDISPATCH;
    }else if ([self.orderTag isEqualToString:@"已发货"]){
        orderDetailVC.orderType = ORDERTOPTYPE_TRANSPORTED;
    }else if ([self.orderTag isEqualToString:@"已完成"]){
        orderDetailVC.orderType = ORDERTOPTYPE_COMMPLETE;
    }else if ([self.orderTag isEqualToString:@"已取消"]){
        orderDetailVC.orderType = ORDERTOPTYPE_CANCELED;
    }
    
    
    [self.navigationController pushViewController:orderDetailVC animated:YES];
}

/*
// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the specified item to be editable.
    return YES;
}
*/

/*
// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // Delete the row from the data source
        [tableView deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
    } else if (editingStyle == UITableViewCellEditingStyleInsert) {
        // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view
    }   
}
*/

/*
// Override to support rearranging the table view.
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
}
*/

/*
// Override to support conditional rearranging of the table view.
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the item to be re-orderable.
    return YES;
}
*/

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
