//
//  ManagementViewController.m
//  ALand
//
//  Created by Z on 16/3/29.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "ManagementViewController.h"
#import "CommodityTableViewCell.h"
#import "UITableView+Category.h"
#import "CommodityMutipleSelectBottomView.h"

#define kCellId @"CommodityTableViewCell.h"
@interface ManagementViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) CommodityMutipleSelectBottomView *bottomView;

@end

@implementation ManagementViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"批量管理";
    [self.view addSubview:self.sorView];
    
    self.sorView.leftTableSelect = ^(NSInteger row){
        CLog(@"l");
    };
    
    self.sorView.rightTableSelect = ^(NSInteger row){
        CLog(@"r");
    };
    
    _tableView = [UITableView plainTableViewWithTarget:self cellNibName:@"CommodityTableViewCell" cellId:kCellId];
    [self.view addSubview:_tableView];
    _tableView.sd_layout.topSpaceToView(self.sorView,0).leftEqualToView(self.view).rightEqualToView(self.view).bottomSpaceToView(self.view, 70);
    _tableView.editing = YES;
    _tableView.allowsMultipleSelectionDuringEditing = YES;
    
    
    
    _bottomView = [CommodityMutipleSelectBottomView viewWithNibName:@"CommodityMutipleSelectBottomView"];
    _bottomView.frame = CGRectMake(0, kHeight - 64 - 70, kWidth, 70 + 64);
    [self.view addSubview:_bottomView];
    
    
    [_bottomView.buttonSelectAll addTarget:self action:@selector(selectAll:) forControlEvents:UIControlEventTouchUpInside];
    // Do any additional setup after loading the view.
}

#pragma mark =========== action ===========

- (void)selectAll:(UIButton *)btn {//tag 等于1表示全选
    if (btn.tag == 0) {
        [self.bottomView selectAll];
        for (int i = 0; i < 10; i ++) {
            NSIndexPath *indexPath = [NSIndexPath indexPathForItem:i inSection:0];
            [self.tableView selectRowAtIndexPath:indexPath animated:YES scrollPosition:UITableViewScrollPositionTop];
        }
        
        btn.tag = 1;
    }else{
        [self.bottomView deselectAll];
        for (int i = 0; i < 10; i ++) {
            NSIndexPath *indexPath = [NSIndexPath indexPathForItem:i inSection:0];
            [self.tableView deselectRowAtIndexPath:indexPath animated:YES];
        }
        
        btn.tag = 0;
    }
}



#pragma mark =========== tableview delegate ===========

- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        
    }
}

- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    return YES;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 10;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    CommodityTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:kCellId forIndexPath:indexPath];

    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 130;
}



#pragma mark =========== lazyloading ===========

- (CommodityManagementSortView *)sorView {
    if (!_sorView) {
        _sorView = [[CommodityManagementSortView new] sortView];
        _sorView.frame = CGRectMake(0, 0, kWidth, 49);
    }
    return _sorView;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
