//
//  HomeCollectionViewController.m
//  ALand
//
//  Created by Z on 16/3/22.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "HomeCollectionViewController.h"
#import "MoneyView.h"
#import "HomeCollectionViewCell.h"
#import "CommodityListViewController.h"
#import "AddCommodityViewController.h"
#import "SDCycleScrollView.h"
#import "CommodityManagementViewController.h"
#import "OrderViewController.h"
#import "StoreManagermentViewController.h"

#define kHomeCollectionViewID @"HomeCollectionViewID"
#define kCollectionViewHeadHeight 350

@interface HomeCollectionViewController ()<UICollectionViewDataSource, UICollectionViewDelegate,SDCycleScrollViewDelegate>
@property (nonatomic, strong) NSArray *cellTitle;
@property (nonatomic, strong) UICollectionView *collectionView;
@end

@implementation HomeCollectionViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.automaticallyAdjustsScrollViewInsets = NO;
    
    _cellTitle = @[@"商品管理",@"订单管理",@"分销管理",@"客户管理",@"店铺管理",@"邀请合伙人",@"aland商城",@""];
    
    
    
    //添加collectionview
    UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc] init];
    layout.minimumLineSpacing = 1;
    layout.minimumInteritemSpacing = 1;
    layout.itemSize = CGSizeMake((ScreenSize.width - 3) / 4, (ScreenSize.width - 3) / 4 - 10);
    
    self.collectionView = [[UICollectionView alloc] initWithFrame:CGRectMake(0, 0, 0, 0) collectionViewLayout:layout];
    _collectionView.backgroundColor = kBacroundColor;
    _collectionView.delegate = self;
    _collectionView.dataSource = self;
    
    _collectionView.contentInset = UIEdgeInsetsMake(kCollectionViewHeadHeight, 0, 0, 0);
    
    //注册cell
    [_collectionView registerNib:[UINib nibWithNibName:@"HomeCollectionViewCell" bundle:[NSBundle mainBundle]] forCellWithReuseIdentifier:kHomeCollectionViewID];

    [self.view addSubview:_collectionView];
    
    _collectionView.sd_layout.topEqualToView(self.view).leftEqualToView(self.view).rightEqualToView(self.view).bottomSpaceToView(self.view, 49);
    [_collectionView updateLayout];
    
    //中间的收入
    MoneyView *viewMoney = [MoneyView viewWithNibName:@"MoneyView"];
    viewMoney.frame = CGRectMake(0, 0 - kCollectionViewHeadHeight, ScreenSize.width, 340);
    [self.collectionView addSubview:viewMoney];
    
    
    //添加商品按钮
    UIView *viewAdd = [[UIView alloc] initWithFrame:CGRectMake(0, -51, ScreenSize.width, 50)];
    viewAdd.backgroundColor = [UIColor whiteColor];
    [self.collectionView addSubview:viewAdd];
    
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    [viewAdd addSubview:button];
    [button addTarget:self action:@selector(touchAddAction) forControlEvents:UIControlEventTouchUpInside];
    button.sd_layout.centerXEqualToView(viewAdd).centerYEqualToView(viewAdd).widthIs(100).heightIs(23);
    [button setImage:[UIImage imageNamed:@"addbutton"] forState:UIControlStateNormal];
    
    //轮播图
    //轮播网络图片
//    SDCycleScrollView *scrollView = [SDCycleScrollView cycleScrollViewWithFrame:CGRectMake(0, 0, 0, 0) delegate:self placeholderImage:[UIImage imageNamed:@"cyclescrollplaceholder"]];
//    scrollView.imageURLStringsGroup = @[@"0",@"0"];
    
    //轮播本地图片
    SDCycleScrollView *scrollView = [SDCycleScrollView cycleScrollViewWithFrame:CGRectMake(0, 0, 0, 0) imageNamesGroup:@[@"cyclescrollplaceholder",@"cyclescrollplaceholder"]];
    
    
    scrollView.bannerImageViewContentMode = UIViewContentModeScaleAspectFill;
    scrollView.autoScrollTimeInterval = 3;
    [self.collectionView addSubview:scrollView];
    scrollView.sd_layout.topSpaceToView(viewMoney,5).widthIs(ScreenSize.width).bottomSpaceToView(viewAdd, 5);
    
    
    // Do any additional setup after loading the view.
}


- (void)touchAddAction {
    CLog(@"添加商品");
    AddCommodityViewController *addVC = [[AddCommodityViewController alloc] init];
    addVC.hidesBottomBarWhenPushed = YES;
    [self.navigationController pushViewController:addVC animated:YES];

}


- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView {
    return 1;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.cellTitle.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    HomeCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:kHomeCollectionViewID forIndexPath:indexPath];
    //cell.backgroundColor = kRandomColor;
    cell.labelCellTitle.text = self.cellTitle[indexPath.row];
    return cell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    switch (indexPath.row) {
        case 0://商品管理
        {
            CommodityManagementViewController *managementVC = [[CommodityManagementViewController alloc] init];
            managementVC.hidesBottomBarWhenPushed = YES;
            [self.navigationController pushViewController:managementVC animated:YES];
            
        }
            break;
        case 1://订单管理
        {
            OrderViewController *orderVC = [[OrderViewController alloc] init];
            orderVC.hidesBottomBarWhenPushed = YES;
            [self.navigationController pushViewController:orderVC animated:YES];
        }
            
            break;
        case 2://分销管理
        {
            
        }
            
            break;
        case 3://客户管理
        {
        
        
        }
            break;
        case 4://店铺管理
        {
            StoreManagermentViewController *storeVC = [[StoreManagermentViewController alloc] initWithNibName:@"StoreManagermentViewController" bundle:[NSBundle mainBundle]];
            storeVC.hidesBottomBarWhenPushed = YES;
            [self.navigationController pushViewController:storeVC animated:YES];

            
        }
            
            break;
        case 5://邀请合伙人
        {
        
        }
            
            break;
        case 6://aland商城
        {
        
        }
            
            break;
        case 7:
        {
        
        }
            
            break;
            
        default:
            break;
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
