//
//  CommodityManagementViewController.m
//  ALand
//
//  Created by Z on 16/3/28.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "CommodityManagementViewController.h"
#import "CommodityManagementTopView.h"
#import "UITableView+Category.h"
#import "CommodityTableViewCell.h"

#define kCellId @"CommodityTableViewCell.h"
@interface CommodityManagementViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) CommodityManagementTopView *topView;
@property (nonatomic, strong) UITableView *tableView;
@end

@implementation CommodityManagementViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"商品管理";
    
    UIBarButtonItem *rightBtn = [[UIBarButtonItem alloc] initWithImage:[UIImage imageNamed:@"searchIcon"] style:UIBarButtonItemStyleDone target:self action:@selector(searchAct)];
    rightBtn.tintColor = kTextColorDarkGray;
    self.navigationItem.rightBarButtonItem = rightBtn;
    
    
    [self.view addSubview:self.topView];
    [self.view addSubview:self.sorView];
    self.sorView.leftTableSelect = ^(NSInteger row){
        CLog(@"l");
    };
    
    self.sorView.rightTableSelect = ^(NSInteger row){
        CLog(@"r");
    };
    
    //
    _tableView = [UITableView plainTableViewWithTarget:self cellNibName:@"CommodityTableViewCell" cellId:kCellId];
    [self.view addSubview:_tableView];
    _tableView.sd_layout.topSpaceToView(self.sorView,0).leftEqualToView(self.view).rightEqualToView(self.view).bottomEqualToView(self.view);
    // Do any additional setup after loading the view.
}




#pragma mark =========== action ===========

- (void)searchAct {
    [self.sorView hide];
    CLog(@"search");
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.sorView hide];
}

#pragma mark =========== tableview delegate ===========

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 10;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    CommodityTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:kCellId forIndexPath:indexPath];
    
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 130;
}

#pragma mark =========== lazy loading ===========
- (CommodityManagementSortView *)sorView {
    if (!_sorView) {
        _sorView = [[CommodityManagementSortView new] sortView];
        _sorView.frame = CGRectMake(0, _topView.bottom - 50, kWidth, 49);
    }
    return _sorView;
}

- (CommodityManagementTopView *)topView {
    if (!_topView) {
        _topView = [CommodityManagementTopView viewWithNibName:@"CommodityManagementTopView"];
        _topView.frame = CGRectMake(0, 0, kWidth, 64 + 64);
    }
    return _topView;
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:NO];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
