//
//  CommodityListViewController.m
//  ALand
//
//  Created by Z on 16/3/23.
//  Copyright © 2016年 Z. All rights reserved.
//

#import "CommodityListViewController.h"
#import "CommodityListCollectionViewCell.h"
#import "SortView.h"
#import "CommodityDetailViewController.h"
#define kCellID @"commodityCell"
@interface CommodityListViewController ()<UICollectionViewDataSource, UICollectionViewDelegate>
@property (nonatomic, strong) UICollectionView *collectionView;
@property (nonatomic, strong) SortView *sortView;
@end

@implementation CommodityListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"商品列表";
    self.view.backgroundColor = kBacroundColor;
    [self setUpSortView];
    [self setUpCollectionView];
    // Do any additional setup after loading the view.
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:NO];
}

- (void)setUpSortView {
    _sortView = [[[SortView alloc] init] customNew];
    [self.view addSubview:_sortView];
    _sortView.sd_layout.topSpaceToView(self.view,1).leftEqualToView(self.view).rightEqualToView(self.view).heightIs(44);
    _sortView.backgroundColor = [UIColor whiteColor];
    
    
    //点击排序列表之后回调传入选中行数
    _sortView.selecedBlock = ^(NSInteger row){
        CLog(@"%ld", (long)row);
    };

}


- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.sortView hide];
}


- (void)setUpCollectionView {
    UICollectionViewFlowLayout *layOut = [[UICollectionViewFlowLayout alloc] init];
    layOut.minimumLineSpacing = 10;
    layOut.itemSize = CGSizeMake((ScreenSize.width - 30)/2, ScreenSize.height / 2.2);
    
    _collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layOut];
    [self.view addSubview:_collectionView];
    _collectionView.sd_layout.topSpaceToView(self.view, 50).leftEqualToView(self.view).bottomEqualToView(self.view).rightEqualToView(self.view);
    _collectionView.contentInset = UIEdgeInsetsMake(0, 10, 0, 10);
    _collectionView.delegate = self;
    _collectionView.dataSource = self;
    _collectionView.backgroundColor = kBacroundColor;
    [_collectionView registerNib:[UINib nibWithNibName:@"CommodityListCollectionViewCell" bundle:[NSBundle mainBundle]] forCellWithReuseIdentifier:kCellID];
}


- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return 20;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    CommodityDetailViewController *detailVC = [[CommodityDetailViewController alloc] init];
    [self.navigationController pushViewController:detailVC animated:YES];
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    CommodityListCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:kCellID forIndexPath:indexPath];
    
    //假数据
    NSArray *arr = @[@"234",@"23",@"234234",@"2344",@"33",@"2",@"234",@"23",@"234234",@"2344",@"33",@"2",@"234",@"23",@"234234",@"2344",@"33",@"2",@"234",@"23",@"234234",@"2344",@"33",@"2"];
    cell.labelSalePrice.text = arr[indexPath.row];
    return cell;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
