//
//  AddCommodityViewController.m
//  ALand
//
//  Created by Z on kMargin/3/25.
//  Copyright © 20kMargin年 Z. All rights reserved.
//

#import "AddCommodityViewController.h"
#import "AddCommodityCollectionViewCell.h"
#import "AddCommodityHeaderView.h"
#import "AddCommodityHeaderCollectionReusableView.h"
#import "HotCommodityCell.h"
#import "AddCommodityFooterCollectionReusableView.h"
#import "CommodityListViewController.h"

#define kHotCellId @"addCommodityCellHot"
#define kCellId @"addCommodityCell"
#define kHeaderId @"headerId"
#define kFooterId @"footerId"
#define kMargin 0
@interface AddCommodityViewController ()<UICollectionViewDataSource, UICollectionViewDelegate, UICollectionViewDelegateFlowLayout>

@property (nonatomic, strong) UICollectionView *collectionView;
@end

@implementation AddCommodityViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"添加商品";
    [self setUpCollectionView];
    [self updateStatueBarAppearance];
    // Do any additional setup after loading the view.
}

- (void)setUpdate {
    
}

//设置navigationbar颜色
- (UIStatusBarStyle)preferredStatusBarStyle {
    return UIStatusBarStyleDefault;
}

//隐藏navigationbar
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:NO];
}

- (void)setUpCollectionView {
    UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc] init];
    _collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
    [self.view addSubview:_collectionView];
    _collectionView.sd_layout.topEqualToView(self.view).leftEqualToView(self.view).bottomEqualToView(self.view).rightEqualToView(self.view);
    _collectionView.delegate = self;
    _collectionView.dataSource = self;
    _collectionView.backgroundColor = kSysWhite;
    _collectionView.contentInset = UIEdgeInsetsMake(0, kMargin, 0, kMargin);
    
    //cell
    [_collectionView registerNib:[UINib nibWithNibName:@"HotCommodityCell" bundle:[NSBundle mainBundle]] forCellWithReuseIdentifier:kHotCellId];
    
    [_collectionView registerNib:[UINib nibWithNibName:@"AddCommodityCollectionViewCell" bundle:[NSBundle mainBundle]] forCellWithReuseIdentifier:kCellId];
    
    //header
    [_collectionView registerNib:[UINib nibWithNibName:@"AddCommodityHeaderCollectionReusableView" bundle:[NSBundle mainBundle]] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:kHeaderId];
    
    [_collectionView registerNib:[UINib nibWithNibName:@"AddCommodityFooterCollectionReusableView" bundle:[NSBundle mainBundle]] forSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:kFooterId];
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout referenceSizeForFooterInSection:(NSInteger)section {
    return CGSizeMake(kWidth, 30);
}

#pragma mark ==============collectionViewHeader==============
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout referenceSizeForHeaderInSection:(NSInteger)section {
    return CGSizeMake(ScreenSize.width, 44);
}

- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath {
    
    if (kind == UICollectionElementKindSectionHeader) {
        
        AddCommodityHeaderCollectionReusableView *reuseHeaderView = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:kHeaderId forIndexPath:indexPath];
        if (indexPath.section == 0) {
            [reuseHeaderView sectionHot];
        }else{
            [reuseHeaderView sectionNormalWithTitle:@"分类"];
        }
        return reuseHeaderView;
        
    }else if (kind == UICollectionElementKindSectionFooter){
        
        AddCommodityFooterCollectionReusableView *reuseFooter = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:kFooterId forIndexPath:indexPath];
        
        
        return reuseFooter;
    }
    
    
    return nil;
    
    
}

#pragma mark ============== items ==============

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.section == 0) {
        return CGSizeMake((ScreenSize.width - kMargin * 2)/3, kAutoValue(100));
    }else{
        return CGSizeMake((ScreenSize.width - kMargin * 2)/4, kAutoValue(160));
    }
}

-(CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout minimumInteritemSpacingForSectionAtIndex:(NSInteger)section{
    
    //两个item的列间距
    
    return 0;
    
}
-(CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout minimumLineSpacingForSectionAtIndex:(NSInteger)section{
    
    //如果一组中有多行item，设置行间距
    
    return 0;
    
}

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView {
    return 5;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    if (section == 0) {
        return 3;
    }else{
        return 6;
    }
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.section == 0) {
        HotCommodityCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:kHotCellId forIndexPath:indexPath];
        
//        
        if ((int)indexPath.row % 3 == 2) {
            [cell showRight];
        }else{
            [cell hideRight];
        }
        return cell;
    }else{
        
        AddCommodityCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:kCellId forIndexPath:indexPath];
        
        
        
        if ((int)indexPath.row / 4 == 0) {
            [cell showTopLine];
        }else{
            [cell hideTopLine];
        }
        
        if ((int)indexPath.row % 4 == 0) {
            [cell showLeftLine];
        }else{
            [cell hideLeftLine];
        }
        return cell;
    }
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
        CommodityListViewController *commodityVC = [[CommodityListViewController alloc] init];
        commodityVC.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:commodityVC animated:YES];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
