#!/usr/bin/env python
# -*- coding: utf-8 -*-

import requests
from urllib import parse
import oss2
import datetime, os
from tqdm import tqdm
from moviepy.editor import VideoFileClip
from moviepy.audio.io.AudioFileClip import AudioFileClip
import time
from app.models.wm_option import WMOption


def download_file(url, file_dir, file_name):
    print(f"开始下载：{url}")
    try:
        if not os.path.exists(file_dir):
            os.makedirs(file_dir)
        # 下载
        local_file_path = os.path.join(file_dir, file_name)
        print(local_file_path)
        # 发起 GET 请求，获取文件大小
        response = requests.get(url, headers={}, stream=True, timeout=30)
        print('发起 GET 请求，获取文件大小')
        file_size = int(response.headers.get('content-length', 0))
        print(f'file_size:{file_size}')
        # 下载文件，并显示下载进度条
        chunk_size = 1024
        with open(local_file_path, 'wb') as file, tqdm(
            desc='Downloading file', total=file_size, unit='B', unit_scale=True, unit_divisor=1024,
            miniters=1, ascii=True) as progress_bar:
            for data in response.iter_content(chunk_size=chunk_size):
                # 更新进度条
                progress_bar.update(len(data))
                # 写入文件
                file.write(data)
        print(f"下载完成：{local_file_path}")
        return local_file_path
    except Exception as e:
        err_info = "download_file 异常：" + str(e)
        print(err_info)
        raise err_info



def download_file2(url, file_dir, file_name):
    try:
        if not os.path.exists(file_dir):
            os.makedirs(file_dir)
        local_file_path = os.path.join(file_dir, file_name)
        response = requests.get(url, stream=True)
        response.raise_for_status()  # 抛出HTTPError异常
        with open(local_file_path, "wb") as f:
            for chunk in response.iter_content(chunk_size=1024):
                if chunk:
                    f.write(chunk)
        print(f"文件下载成功：{local_file_path}")
        return local_file_path
    except requests.exceptions.RequestException as e:
        print(f"下载文件时出现错误：{e}")
        raise e




def upload_to_oss(local_file_path, file_name_format):
    print(f"上传文件：{local_file_path} 到阿里云OSS")
    access_key = "LTAIrA1H432TFke7"
    access_secret = "BZDCuyIYd4lAOX5UOh8wK93GuUynkR"
    oss_endpoint = "oss-cn-beijing.aliyuncs.com"
    oss_bucket = "wm-video-pic"
    oss_folder = "wm_gen_video"
    try:
        # 阿里云账号AccessKey拥有所有API的访问权限，风险很高。强烈建议您创建并使用RAM用户进行API访问或日常运维，请登录RAM控制台创建RAM用户。
        auth = oss2.Auth(access_key, access_secret)
        # 填写Bucket名称。
        bucket = oss2.Bucket(auth, oss_endpoint, oss_bucket)
        # 上传文件到OSS。
        now = datetime.datetime.now()
        datetime_str = now.strftime('%Y%m%d%H%M%S')
        oss_file_path = oss_folder + '/' + datetime_str + '/' + file_name_format
        # 上传文件
        with open(local_file_path, 'rb') as file:
            result = bucket.put_object(oss_file_path, file)
            if result.status == 200:
                oss_url = f"https://{oss_bucket}.{oss_endpoint}/{oss_file_path}"
                print(f"阿里云OSS上传成功，链接：{oss_url}")
                return oss_url
            else:
                print(f"上传阿里云OSS失败")
                raise "上传阿里云OSS失败"
    except Exception as e:
        err_info = "上传阿里云OSS异常：" + str(e)
        print(err_info)
        if 'Connection aborted' in str(e):
            print('上传oss被中断，重试')
            return upload_to_oss(local_file_path, file_name_format)
        else:
            raise err_info


def get_video_length(video_file):
    try:
        # 加载视频文件
        video = VideoFileClip(video_file)
        # 获取视频长度，单位为秒
        duration = video.duration
        # 释放资源
        video.close()
        return round(duration, 2)
    except Exception as e:
        err_info = "get_video_length 异常：" + str(e)
        raise err_info


def get_audio_length(audio_file):
    try:
        # 加载文件
        audio = AudioFileClip(audio_file)
        # 获取长度，单位为秒
        duration = audio.duration
        # 释放资源
        audio.close()
        return round(duration, 2)
    except Exception as e:
        err_info = "get_audio_length 异常：" + str(e)
        raise err_info


def get_wm_option(wm_key):
    wm_option = WMOption.query.filter_by(option_key=wm_key).first()
    if not wm_option:
        return ""
    else:
        return wm_option.option_value
