/*
 * Decompiled with CFR 0.152.
 */
package com.wmdigit.service.aidl.model;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;

public class DetectResult
implements Parcelable {
    private int code = 0;
    private Bitmap bitmap;
    private List<String> productCodes;
    public static final Parcelable.Creator<DetectResult> CREATOR = new Parcelable.Creator<DetectResult>(){

        public DetectResult createFromParcel(Parcel in) {
            return new DetectResult(in);
        }

        public DetectResult[] newArray(int size) {
            return new DetectResult[size];
        }
    };

    public DetectResult() {
        this.bitmap = null;
        this.productCodes = new ArrayList<String>();
    }

    public DetectResult(int code, Bitmap bitmap, List<String> productCodes) {
        this.code = code;
        this.bitmap = bitmap;
        this.productCodes = productCodes != null ? new ArrayList<String>(productCodes) : new ArrayList();
    }

    protected DetectResult(Parcel in) {
        this.readFromParcel(in);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.code);
        dest.writeInt(this.productCodes.size());
        StringBuilder sb = new StringBuilder();
        for (String productCode : this.productCodes) {
            sb.append(productCode).append(",");
        }
        dest.writeString(sb.toString());
        if (this.bitmap == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeParcelable((Parcelable)this.bitmap, flags);
        }
    }

    public void readFromParcel(Parcel in) {
        int hasBitmap;
        this.code = in.readInt();
        int size = in.readInt();
        String productCodesStr = in.readString();
        this.productCodes = new ArrayList<String>();
        if (productCodesStr != null && !productCodesStr.isEmpty()) {
            String[] codes;
            for (String code : codes = productCodesStr.split(",")) {
                if (code.isEmpty()) continue;
                this.productCodes.add(code);
            }
        }
        if ((hasBitmap = in.readInt()) == 0) {
            this.bitmap = null;
        } else {
            try {
                this.bitmap = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
            }
            catch (Exception e) {
                this.bitmap = null;
                e.printStackTrace();
            }
        }
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public List<String> getProductCodes() {
        return this.productCodes;
    }

    public void setProductCodes(List<String> productCodes) {
        this.productCodes = productCodes != null ? new ArrayList<String>(productCodes) : new ArrayList();
    }
}

