package com.wmdigit.cateringservicedemo.data;

/**
 * 错误码
 * @author dizi
 */
public class ErrorCode {
    // 成功
    public static final int ERROR_CODE_SUCCESS = 0;

    // 摄像头不可用的错误码
    public static final int ERROR_CODE_CAMERA_NOT_AVAILABLE = 2000;

    // 未激活的错误码
    public static final int ERROR_CODE_NOT_ACTIVATED = 2001;

    // 学习数据初始化未完成的错误码
    public static final int ERROR_CODE_LEARNING_DATA_INIT_NOT_COMPLETED = 2002;

    // 摄像头未裁剪的错误码
    public static final int ERROR_CODE_CAMERA_NOT_CROPPED = 2003;

    // 区域内无对象的错误码
    public static final int ERROR_CODE_NO_OBJECT_IN_AREA = 2004;

    /**
     * 根据错误码获取对应的错误消息
     *
     * @param errorCode 错误码，表示不同的错误类型或状态
     * @return 返回与错误码对应的错误消息字符串
     */
    public static String getErrorMessage(int errorCode) {
        // 默认错误消息
        String message = "未知错误";

        // 根据不同的错误码设置对应的错误消息
        switch (errorCode) {
            // 成功不是错误情况，但作为一种特殊处理
            case ERROR_CODE_SUCCESS:
                message = "成功";
                break;

            // 摄像头不可用错误
            case ERROR_CODE_CAMERA_NOT_AVAILABLE:
                message = "摄像头不可用";
                break;

            // 未激活错误
            case ERROR_CODE_NOT_ACTIVATED:
                message = "未激活";
                break;

            // 学习数据初始化未完成错误
            case ERROR_CODE_LEARNING_DATA_INIT_NOT_COMPLETED:
                message = "学习数据初始化未完成";
                break;

            // 摄像头未裁剪错误
            case ERROR_CODE_CAMERA_NOT_CROPPED:
                message = "摄像头未裁剪";
                break;

            // 检测区域内无对象错误
            case ERROR_CODE_NO_OBJECT_IN_AREA:
                message = "检测区域内无对象";
                break;

            // 默认情况，保持message为"未知错误"
            default:
                break;
        }
        // 返回相应的错误消息
        return message;
    }
}