package com.wmdigit.cateringservicedemo.data;

import com.wmdigit.cateringservicedemo.model.ApiButton;

import java.util.ArrayList;
import java.util.List;

/**
 * 常量类，用于存储API按钮数据的集合
 * 本类主要包含三个静态常量，每个常量是一个ApiButton对象的列表，
 * 分别用于存储主流程数据、状态信息数据和其他数据
 * @author dizi
 */
public class Constant {
    /**
     * 主流程数据集合，包含初始化、注册、反注册和重新识别等操作的API按钮
     */
    public static final List<ApiButton> mainProcessData = new ArrayList<ApiButton>(){
        {
            add(new ApiButton("3.1", "bindService", "绑定服务程序"));
            add(new ApiButton("3.2", "unbindService", "解绑服务程序"));
            add(new ApiButton("3.3", "init", "初始化学习数据"));
            add(new ApiButton("3.4", "importProducts", "导入商品资料"));
            add(new ApiButton("3.5", "registerDetectionListener", "注册识别结果回调"));
            add(new ApiButton("3.6", "unregisterDetectionListener", "反注册识别结果回调"));
            add(new ApiButton("3.7", "autoDetect", "重新识别"));
        }
    };

    /**
     * 状态信息数据集合，包含获取激活状态、获取摄像头裁剪状态和获取算法初始化状态的API按钮
     */
    public static final List<ApiButton> statusInfoData = new ArrayList<ApiButton>(){
        {
            add(new ApiButton("4.1", "checkServiceAppInstalled", "获取服务程序安装状态"));
            add(new ApiButton("4.2", "checkServiceConnected", "获取服务连接状态"));
            add(new ApiButton("4.3", "checkActivation", "获取激活状态"));
            add(new ApiButton("4.4", "checkCameraCrop", "获取摄像头裁剪状态"));
            add(new ApiButton("4.5", "checkLearningDataInitCompleted", "获取算法初始化状态"));
        }
    };

    /**
     * 其他数据集合，包含打开设置页和重置摄像头背景的API按钮
     */
    public static final List<ApiButton> otherData = new ArrayList<ApiButton>(){
        {
            add(new ApiButton("5.1", "openSettingPage", "打开设置页"));
            add(new ApiButton("5.2", "resetCameraBackground", "重置摄像头背景"));
        }
    };
}
