/*
 * Decompiled with CFR 0.152.
 */
package com.wmdigit.service;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.wmdigit.common.model.ProductsDTO;
import com.wmdigit.service.IOnDetectionListener;
import com.wmdigit.service.IOnInitListener;
import com.wmdigit.service.aidl.model.DetectResult;
import java.util.ArrayList;
import java.util.List;

public interface ICateringInterface
extends IInterface {
    public static final String DESCRIPTOR = "com.wmdigit.service.ICateringInterface";

    public void init(IOnInitListener var1) throws RemoteException;

    public void importProducts(List<ProductsDTO> var1) throws RemoteException;

    public void registerDetectionListener(boolean var1, IOnDetectionListener var2) throws RemoteException;

    public void unregisterDetectionListener() throws RemoteException;

    public DetectResult autoDetect(boolean var1) throws RemoteException;

    public boolean checkActivation() throws RemoteException;

    public boolean checkCameraCrop() throws RemoteException;

    public boolean checkLearningDataInited() throws RemoteException;

    public void openSettingPage() throws RemoteException;

    public void resetCameraBackground() throws RemoteException;

    public static class _Parcel {
        private static <T> T readTypedObject(Parcel parcel, Parcelable.Creator<T> c) {
            if (parcel.readInt() != 0) {
                return (T)c.createFromParcel(parcel);
            }
            return null;
        }

        private static <T extends Parcelable> void writeTypedObject(Parcel parcel, T value, int parcelableFlags) {
            if (value != null) {
                parcel.writeInt(1);
                value.writeToParcel(parcel, parcelableFlags);
            } else {
                parcel.writeInt(0);
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements ICateringInterface {
        static final int TRANSACTION_init = 1;
        static final int TRANSACTION_importProducts = 2;
        static final int TRANSACTION_registerDetectionListener = 3;
        static final int TRANSACTION_unregisterDetectionListener = 4;
        static final int TRANSACTION_autoDetect = 5;
        static final int TRANSACTION_checkActivation = 6;
        static final int TRANSACTION_checkCameraCrop = 7;
        static final int TRANSACTION_checkLearningDataInited = 8;
        static final int TRANSACTION_openSettingPage = 9;
        static final int TRANSACTION_resetCameraBackground = 10;

        public Stub() {
            this.attachInterface(this, ICateringInterface.DESCRIPTOR);
        }

        public static ICateringInterface asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICateringInterface.DESCRIPTOR);
            if (iin != null && iin instanceof ICateringInterface) {
                return (ICateringInterface)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICateringInterface.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IOnInitListener _arg0 = IOnInitListener.Stub.asInterface(data.readStrongBinder());
                    this.init(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    ArrayList _arg0 = data.createTypedArrayList(ProductsDTO.CREATOR);
                    this.importProducts(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    boolean _arg0 = 0 != data.readInt();
                    IOnDetectionListener _arg1 = IOnDetectionListener.Stub.asInterface(data.readStrongBinder());
                    this.registerDetectionListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    this.unregisterDetectionListener();
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    boolean _arg0 = 0 != data.readInt();
                    DetectResult _result = this.autoDetect(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, _result, 1);
                    break;
                }
                case 6: {
                    boolean _result = this.checkActivation();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 7: {
                    boolean _result = this.checkCameraCrop();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 8: {
                    boolean _result = this.checkLearningDataInited();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 9: {
                    this.openSettingPage();
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    this.resetCameraBackground();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ICateringInterface {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICateringInterface.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void init(IOnInitListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICateringInterface.DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)listener);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void importProducts(List<ProductsDTO> products) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICateringInterface.DESCRIPTOR);
                    _data.writeTypedList(products);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDetectionListener(boolean generateBitmap, IOnDetectionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICateringInterface.DESCRIPTOR);
                    _data.writeInt(generateBitmap ? 1 : 0);
                    _data.writeStrongInterface((IInterface)listener);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDetectionListener() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICateringInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DetectResult autoDetect(boolean generateBitmap) throws RemoteException {
                DetectResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICateringInterface.DESCRIPTOR);
                    _data.writeInt(generateBitmap ? 1 : 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = (DetectResult)_Parcel.readTypedObject(_reply, DetectResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean checkActivation() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICateringInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean checkCameraCrop() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICateringInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean checkLearningDataInited() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICateringInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openSettingPage() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICateringInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetCameraBackground() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICateringInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICateringInterface {
        @Override
        public void init(IOnInitListener listener) throws RemoteException {
        }

        @Override
        public void importProducts(List<ProductsDTO> products) throws RemoteException {
        }

        @Override
        public void registerDetectionListener(boolean generateBitmap, IOnDetectionListener listener) throws RemoteException {
        }

        @Override
        public void unregisterDetectionListener() throws RemoteException {
        }

        @Override
        public DetectResult autoDetect(boolean generateBitmap) throws RemoteException {
            return null;
        }

        @Override
        public boolean checkActivation() throws RemoteException {
            return false;
        }

        @Override
        public boolean checkCameraCrop() throws RemoteException {
            return false;
        }

        @Override
        public boolean checkLearningDataInited() throws RemoteException {
            return false;
        }

        @Override
        public void openSettingPage() throws RemoteException {
        }

        @Override
        public void resetCameraBackground() throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

